<?php

namespace App\Services\VAT;

use App\Models\ReceiptLine;
use App\Models\VatAnalysis;

class UkVatService
{
    public function analyzeLine(ReceiptLine $line): VatAnalysis
    {
        $vatRate = $line->vat_rate ?? 20.0;
        $claimable = 0.0;

        if ($line->is_personal) {
            $claimable = 0.0;
        } else {
            // Baseline: assume claimable equals explicit VAT amount if provided, otherwise derive
            if ($line->vat_amount !== null) {
                $claimable = (float) $line->vat_amount;
            } else {
                $claimable = round(($line->line_total * ($vatRate / (100 + $vatRate))), 2);
            }
        }

        return VatAnalysis::updateOrCreate(
            ['receipt_line_id' => $line->id],
            [
                'jurisdiction' => 'UK',
                'vat_rate' => $vatRate,
                'vat_amount_claimable' => $claimable,
                'reasoning' => 'Baseline UK VAT calculation. LLM refinement pending.',
            ]
        );
    }
}


