<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class LibraryTrack extends Model
{
    use HasFactory;

    protected $fillable = [
        'category_id',
        'title',
        'slug',
        'description',
        'transcript',
        'file_path',
        'duration',
        'tags',
        'voice_type',
        'difficulty_level',
        'is_active',
        'play_count',
        'rating',
    ];

    protected $casts = [
        'tags' => 'array',
        'is_active' => 'boolean',
        'play_count' => 'integer',
    ];

    public function category(): BelongsTo
    {
        return $this->belongsTo(LibraryCategory::class, 'category_id');
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeByCategory($query, $categoryId)
    {
        return $query->where('category_id', $categoryId);
    }

    public function scopeByVoiceType($query, $voiceType)
    {
        return $query->where('voice_type', $voiceType);
    }

    public function scopeByDifficulty($query, $difficulty)
    {
        return $query->where('difficulty_level', $difficulty);
    }

    public function incrementPlayCount(): void
    {
        $this->increment('play_count');
    }
}
