<x-app-layout>
    <section class="py-4">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h4 mb-0">Edit Item: {{ $item->name }}</h1>
                <a href="{{ route('admin.items.index') }}" class="btn btn-outline-primary rounded-pill">Back</a>
            </div>

            @if($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="card shadow-sm">
                <div class="card-body">
                    <form method="POST" action="{{ route('admin.items.update', $item) }}" class="row g-3">
                        @csrf
                        @method('PUT')
                        <div class="col-md-6">
                            <label class="form-label">Name</label>
                            <input type="text" name="name" class="form-control" value="{{ old('name', $item->name) }}" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Slug</label>
                            <input type="text" name="slug" class="form-control" value="{{ old('slug', $item->slug) }}" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">SKU</label>
                            <input type="text" name="sku" class="form-control" value="{{ old('sku', $item->sku) }}" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Category</label>
                            <select name="category_id" class="form-select" required>
                                @foreach($categories as $cat)
                                    <option value="{{ $cat->id }}" @selected(old('category_id', $item->category_id)==$cat->id)>{{ $cat->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Season</label>
                            <select name="season_id" class="form-select">
                                <option value="">— None —</option>
                                @foreach($seasons as $s)
                                    <option value="{{ $s->id }}" @selected(old('season_id', $item->season_id)==$s->id)>{{ $s->code }} — {{ $s->label }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-12">
                            <label class="form-label">Description</label>
                            <textarea name="description" class="form-control" rows="4">{{ old('description', $item->description) }}</textarea>
                        </div>

                        <div class="col-12">
                            <label class="form-label">Attributes</label>
                            @php($pairs = old('attr_name') ? collect(old('attr_name'))->map(fn($n,$i)=>[$n, old('attr_value.'.$i)]) : collect($item->attributes ?? [])->map(fn($v,$k)=>[$k,$v]))
                            <div id="attrRows" class="d-flex flex-column">
                                @foreach(($pairs->isEmpty()?collect([['',''],['',''],['','']]):$pairs) as $i => $pair)
                                    <div class="attr-row row g-2 align-items-end mb-2 flex-nowrap">
                                        <div class="col-md-4"><input type="text" class="form-control" name="attr_name[]" placeholder="Key" value="{{ $pair[0] }}"></div>
                                        <div class="col-md-6"><input type="text" class="form-control" name="attr_value[]" placeholder="Value" value="{{ $pair[1] }}"></div>
                                        <div class="col-md-2 d-grid"><button type="button" class="btn btn-outline-secondary remove-attr">Remove</button></div>
                                    </div>
                                @endforeach
                            </div>
                            <div class="mt-2">
                                <button type="button" id="addAttr" class="btn btn-outline-primary btn-sm rounded-pill"><i class="bi bi-plus-lg me-1"></i>Add attribute</button>
                            </div>
                            <small class="text-muted d-block mt-1">Optional key/value pairs (e.g., weight, gauge, type).</small>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">Colour Grid Columns</label>
                            <input type="number" name="colour_grid_columns" class="form-control" min="1" max="8" value="{{ old('colour_grid_columns', $item->colour_grid_columns) }}">
                        </div>
                        <div class="col-md-3 d-flex align-items-end">
                            <div class="form-check">
                                <input type="hidden" name="has_colourways" value="0">
                                <input class="form-check-input" type="checkbox" name="has_colourways" id="has_colourways" value="1" @checked(old('has_colourways', $item->has_colourways))>
                                <label class="form-check-label" for="has_colourways">Has Colourways</label>
                            </div>
                        </div>
                        <div class="col-md-3 d-flex align-items-end">
                            <div class="form-check">
                                <input type="hidden" name="is_active" value="0">
                                <input class="form-check-input" type="checkbox" name="is_active" id="is_active" value="1" @checked(old('is_active', $item->is_active))>
                                <label class="form-check-label" for="is_active">Active</label>
                            </div>
                        </div>

                        <div class="col-12">
                            <hr>
                            <h5 class="mb-3">Colourways</h5>
                            @foreach($item->colourways as $idx => $cw)
                                <div class="row g-2 align-items-end mb-2">
                                    <input type="hidden" name="colourways[{{ $idx }}][id]" value="{{ $cw->id }}">
                                    <div class="col-md-3">
                                        <label class="form-label">Name</label>
                                        <input type="text" class="form-control" name="colourways[{{ $idx }}][name]" value="{{ old("colourways.$idx.name", $cw->name) }}">
                                    </div>
                                    <div class="col-md-2">
                                        <label class="form-label">Colour Code</label>
                                        <input type="text" class="form-control" name="colourways[{{ $idx }}][colour_code]" value="{{ old("colourways.$idx.colour_code", $cw->colour_code) }}">
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label">Image URL</label>
                                        <input type="text" class="form-control" name="colourways[{{ $idx }}][image_path]" value="{{ old("colourways.$idx.image_path", $cw->image_path) }}">
                                    </div>
                                    <div class="col-md-2">
                                        <label class="form-label">Sort</label>
                                        <input type="number" class="form-control" name="colourways[{{ $idx }}][sort_order]" value="{{ old("colourways.$idx.sort_order", $cw->sort_order) }}">
                                    </div>
                                    <div class="col-md-1 form-check">
                                        <input class="form-check-input" type="checkbox" name="colourways[{{ $idx }}][is_active]" value="1" @checked(old("colourways.$idx.is_active", $cw->is_active))>
                                        <label class="form-check-label">Active</label>
                                    </div>
                                    <div class="col-md-1 form-check">
                                        <input class="form-check-input" type="checkbox" name="colourways[{{ $idx }}][remove]" value="1">
                                        <label class="form-check-label text-danger">Remove</label>
                                    </div>
                                </div>
                            @endforeach

                            <div class="mt-3">
                                <h6>Add New Colourways</h6>
                                @for($i=0;$i<3;$i++)
                                    <div class="row g-2 align-items-end mb-2">
                                        <div class="col-md-3">
                                            <label class="form-label">Name</label>
                                            <input type="text" class="form-control" name="new_colourways[{{ $i }}][name]" value="{{ old("new_colourways.$i.name") }}">
                                        </div>
                                        <div class="col-md-2">
                                            <label class="form-label">Colour Code</label>
                                            <input type="text" class="form-control" name="new_colourways[{{ $i }}][colour_code]" value="{{ old("new_colourways.$i.colour_code") }}">
                                        </div>
                                        <div class="col-md-3">
                                            <label class="form-label">Image URL</label>
                                            <input type="text" class="form-control" name="new_colourways[{{ $i }}][image_path]" value="{{ old("new_colourways.$i.image_path") }}">
                                        </div>
                                        <div class="col-md-2">
                                            <label class="form-label">Sort</label>
                                            <input type="number" class="form-control" name="new_colourways[{{ $i }}][sort_order]" value="{{ old("new_colourways.$i.sort_order") }}">
                                        </div>
                                        <div class="col-md-2 form-check">
                                            <input class="form-check-input" type="checkbox" name="new_colourways[{{ $i }}][is_active]" value="1" @checked(old("new_colourways.$i.is_active", 1))>
                                            <label class="form-check-label">Active</label>
                                        </div>
                                    </div>
                                @endfor
                            </div>
                        </div>

                        <div class="col-12">
                            <button type="submit" class="btn btn-primary rounded-pill">Save Changes</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
</x-app-layout>

<script>
    (() => {
        const rows = document.getElementById('attrRows');
        const addBtn = document.getElementById('addAttr');
        function addRow(key='', val=''){
            const wrap = document.createElement('div');
            wrap.className = 'w-100 d-contents';
            wrap.innerHTML = `
                <div class="col-md-4"><input type=\"text\" class=\"form-control\" name=\"attr_name[]\" placeholder=\"Key\" value=\"${key}\"></div>
                <div class="col-md-6"><input type=\"text\" class=\"form-control\" name=\"attr_value[]\" placeholder=\"Value\" value=\"${val}\"></div>
                <div class="col-md-2 d-grid"><button type=\"button\" class=\"btn btn-outline-secondary remove-attr\">Remove</button></div>
            `;
            rows.appendChild(wrap);
        }
        rows?.addEventListener('click', (e)=>{
            if(e.target.classList.contains('remove-attr')){
                const group = e.target.closest('.d-contents');
                if(group){ group.remove(); }
            }
        });
        addBtn?.addEventListener('click', ()=> addRow());
    })();
</script>

