<x-app-layout>
    <section class="py-4">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h4 mb-0">Edit Item: {{ $item->name }}</h1>
                <a href="{{ route('admin.items.index') }}" class="btn btn-outline-primary rounded-pill">Back</a>
            </div>

            @if($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="card shadow-sm">
                <div class="card-body">
                    <form method="POST" action="{{ route('admin.items.update', $item) }}" class="row g-3">
                        @csrf
                        @method('PUT')
                        <div class="col-md-6">
                            <label class="form-label">Name</label>
                            <input type="text" name="name" class="form-control" value="{{ old('name', $item->name) }}" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Slug</label>
                            <input type="text" name="slug" class="form-control" value="{{ old('slug', $item->slug) }}" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">SKU</label>
                            <input type="text" name="sku" class="form-control" value="{{ old('sku', $item->sku) }}" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Category</label>
                            <select name="category_id" class="form-select" required>
                                @foreach($categories as $cat)
                                    <option value="{{ $cat->id }}" @selected(old('category_id', $item->category_id)==$cat->id)>{{ $cat->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Season</label>
                            <select name="season_id" class="form-select">
                                <option value="">— None —</option>
                                @foreach($seasons as $s)
                                    <option value="{{ $s->id }}" @selected(old('season_id', $item->season_id)==$s->id)>{{ $s->code }} — {{ $s->label }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-12">
                            <label class="form-label">Description</label>
                            <textarea name="description" class="form-control" rows="4">{{ old('description', $item->description) }}</textarea>
                        </div>

                        <div class="col-12">
                            <label class="form-label">Attributes</label>
                            @php($pairs = old('attr_name') ? collect(old('attr_name'))->map(fn($n,$i)=>[$n, old('attr_value.'.$i)]) : collect($item->attributes ?? [])->map(fn($v,$k)=>[$k,$v]))
                            <div id="attrRows" class="d-flex flex-column">
                                @foreach(($pairs->isEmpty()?collect([['',''],['',''],['','']]):$pairs) as $i => $pair)
                                    <div class="attr-row row g-2 align-items-end mb-2 flex-nowrap">
                                        <div class="col-md-4"><input type="text" class="form-control" name="attr_name[]" placeholder="Key" value="{{ $pair[0] }}"></div>
                                        <div class="col-md-6"><input type="text" class="form-control" name="attr_value[]" placeholder="Value" value="{{ $pair[1] }}"></div>
                                        <div class="col-md-2 d-grid"><button type="button" class="btn btn-outline-secondary remove-attr">Remove</button></div>
                                    </div>
                                @endforeach
                            </div>
                            <div class="mt-2">
                                <button type="button" class="btn btn-outline-primary btn-sm rounded-pill add-attr"><i class="bi bi-plus-lg me-1"></i>Add attribute</button>
                            </div>
                            <small class="text-muted d-block mt-1">Optional key/value pairs (e.g., weight, gauge, type).</small>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">Colour Grid Columns</label>
                            <input type="number" name="colour_grid_columns" class="form-control" min="1" max="8" value="{{ old('colour_grid_columns', $item->colour_grid_columns) }}">
                        </div>
                        <div class="col-md-3 d-flex align-items-end">
                            <div class="form-check">
                                <input type="hidden" name="has_colourways" value="0">
                                <input class="form-check-input" type="checkbox" name="has_colourways" id="has_colourways" value="1" @checked(old('has_colourways', $item->has_colourways))>
                                <label class="form-check-label" for="has_colourways">Has Colourways</label>
                            </div>
                        </div>
                        <div class="col-md-3 d-flex align-items-end">
                            <div class="form-check">
                                <input type="hidden" name="is_active" value="0">
                                <input class="form-check-input" type="checkbox" name="is_active" id="is_active" value="1" @checked(old('is_active', $item->is_active))>
                                <label class="form-check-label" for="is_active">Active</label>
                            </div>
                        </div>

                        <div class="col-12">
                            <hr>
                            <h5 class="mb-3">Colourways</h5>
                            <div id="cwSortable" class="cw-sortable">
                            @foreach($item->colourways()->ordered()->get() as $idx => $cw)
                                <div class="card shadow-sm mb-2" data-cw-id="{{ $cw->id }}">
                                    <div class="card-body">
                                        <div class="row g-2 align-items-center">
                                            <input type="hidden" name="colourways[{{ $idx }}][id]" value="{{ $cw->id }}">
                                            <div class="col-auto">
                                                @if($cw->image_path)
                                                    <img src="{{ $cw->image_path }}" alt="swatch" class="rounded" style="width:40px;height:40px;object-fit:cover;">
                                                @else
                                                    <div class="rounded-circle border" style="width:40px;height:40px;background:#eee;"></div>
                                                @endif
                                            </div>
                                            <div class="col-md-3">
                                                <input type="text" class="form-control" name="colourways[{{ $idx }}][name]" placeholder="Name" value="{{ old("colourways.$idx.name", $cw->name) }}">
                                            </div>
                                            <div class="col-md-2">
                                                <input type="text" class="form-control" name="colourways[{{ $idx }}][colour_code]" placeholder="Colour code" value="{{ old("colourways.$idx.colour_code", $cw->colour_code) }}">
                                            </div>
                                            <div class="col-md-3">
                                                <input type="text" class="form-control" name="colourways[{{ $idx }}][image_path]" placeholder="Image URL" value="{{ old("colourways.$idx.image_path", $cw->image_path) }}">
                                            </div>
                                            <div class="col-auto d-flex align-items-center gap-1">
                                                <input type="hidden" class="sort-field" name="colourways[{{ $idx }}][sort_order]" value="{{ old("colourways.$idx.sort_order", $cw->sort_order) }}">
                                                <button type="button" class="btn btn-outline-secondary btn-sm move-up" title="Move up"><i class="bi bi-arrow-up"></i></button>
                                                <button type="button" class="btn btn-outline-secondary btn-sm move-down" title="Move down"><i class="bi bi-arrow-down"></i></button>
                                            </div>
                                            <div class="col-auto form-check">
                                                <input class="form-check-input" type="checkbox" name="colourways[{{ $idx }}][is_active]" value="1" @checked(old("colourways.$idx.is_active", $cw->is_active))>
                                                <label class="form-check-label">Active</label>
                                            </div>
                                            <div class="col-auto form-check">
                                                <input class="form-check-input" type="checkbox" name="colourways[{{ $idx }}][remove]" value="1">
                                                <label class="form-check-label text-danger">Remove</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                            </div>

                            <div class="mt-3">
                                <h6 class="mb-2">Add New Colourways</h6>
                                <div id="newColourwayRows" class="d-flex flex-column"></div>
                                <button type="button" class="btn btn-outline-primary btn-sm rounded-pill add-colourway"><i class="bi bi-plus-lg me-1"></i>Add colourway</button>
                            </div>
                        </div>

                        <div class="col-12">
                            <button type="submit" class="btn btn-primary rounded-pill">Save Changes</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
</x-app-layout>

<template id="attrRowTemplate">
    <div class="attr-row row g-2 align-items-end mb-2">
        <div class="col-md-4"><input type="text" class="form-control" name="attr_name[]" placeholder="Key"></div>
        <div class="col-md-6"><input type="text" class="form-control" name="attr_value[]" placeholder="Value"></div>
        <div class="col-md-2 d-grid"><button type="button" class="btn btn-outline-secondary remove-attr">Remove</button></div>
    </div>
</template>

<script>
    (function(){
        const rows = document.getElementById('attrRows');
        const tpl = document.getElementById('attrRowTemplate');
        function addRow(){
            if(!rows || !tpl) return;
            const node = tpl.content.firstElementChild.cloneNode(true);
            rows.appendChild(node);
        }
        document.addEventListener('click', function(e){
            const add = e.target.closest('.add-attr');
            if(add){ e.preventDefault(); addRow(); return; }
            const rm = e.target.closest('.remove-attr');
            if(rm){ e.preventDefault(); const row = rm.closest('.attr-row'); if(row){ row.remove(); } }
        });
    })();
</script>

<script>
    // Drag & drop reordering for colourways
    (function(){
        const list = document.getElementById('cwSortable');
        if(!list) return;
        function renumber(){
            [...list.querySelectorAll('.card')].forEach((card, idx)=>{
                const input = card.querySelector('.sort-field');
                if(input) input.value = idx;
            });
        }
        document.addEventListener('click', function(e){
            const up = e.target.closest('.move-up');
            const down = e.target.closest('.move-down');
            if(up){
                e.preventDefault();
                const card = up.closest('.card');
                const prev = card?.previousElementSibling;
                if(prev){ list.insertBefore(card, prev); renumber(); saveOrder(); }
            }
            if(down){
                e.preventDefault();
                const card = down.closest('.card');
                if(card.nextElementSibling){ list.insertBefore(card.nextElementSibling, card); renumber(); saveOrder(); }
            }
        });
        renumber();
        function saveOrder(){
            const ids = [...list.querySelectorAll('.card')].map(c=>c.getAttribute('data-cw-id'));
            fetch("{{ route('admin.items.colourways.reorder', $item) }}", {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name=csrf-token]')?.getAttribute('content')
                },
                body: JSON.stringify({ ids })
            }).catch(()=>{});
        }
    })();
</script>

<template id="newColourwayTemplate">
    <div class="card shadow-sm mb-2">
        <div class="card-body">
            <div class="row g-2 align-items-center">
                <div class="col-md-3"><input type="text" class="form-control" name="new_colourways[INDEX][name]" placeholder="Name"></div>
                <div class="col-md-2"><input type="text" class="form-control" name="new_colourways[INDEX][colour_code]" placeholder="Colour code"></div>
                <div class="col-md-3"><input type="text" class="form-control" name="new_colourways[INDEX][image_path]" placeholder="Image URL"></div>
                <div class="col-md-1"><input type="number" class="form-control" name="new_colourways[INDEX][sort_order]" placeholder="Sort" value="0"></div>
                <div class="col-auto form-check">
                    <input class="form-check-input" type="checkbox" name="new_colourways[INDEX][is_active]" value="1" checked>
                    <label class="form-check-label">Active</label>
                </div>
                <div class="col-auto">
                    <button type="button" class="btn btn-outline-secondary btn-sm remove-new-cw">Remove</button>
                </div>
            </div>
        </div>
    </div>
    </template>

<script>
    (function(){
        const list = document.getElementById('newColourwayRows');
        const tpl = document.getElementById('newColourwayTemplate');
        let idx = 0;
        function addCw(){
            const html = tpl.innerHTML.replaceAll('INDEX', idx++);
            const div = document.createElement('div');
            div.innerHTML = html.trim();
            list.appendChild(div.firstElementChild);
        }
        document.addEventListener('click', function(e){
            if(e.target.closest('.add-colourway')){ e.preventDefault(); addCw(); }
            if(e.target.closest('.remove-new-cw')){ e.preventDefault(); const card = e.target.closest('.card'); if(card){ card.remove(); } }
        });
    })();
</script>

