<?php

namespace Database\Seeders;

use App\Models\User;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Ensure demo admin exists
        $admin = User::query()->firstOrCreate(
            ['email' => 'admin@example.com'],
            [
                'name' => 'Demo Admin',
                'password' => bcrypt('password'),
                'email_verified_at' => now(),
                'remember_token' => Str::random(10),
            ]
        );

        // Create a long-lived API token for convenience (revoke in prod)
        if (!method_exists($admin, 'createToken')) {
            return;
        }
        if (!$admin->tokens()->where('name', 'demo')->exists()) {
            $token = $admin->createToken('demo');
            $this->command?->info('Demo API token: '.$token->plainTextToken);
        }
    }
}
