<?php
$meta = [
  'title' => 'Website Care & Hosting | Newcastle',
  'description' => 'Keep your site safe, fast, and up-to-date. Care plans for updates, backups, security, and hosting.',
  'canonical' => 'https://neilwiddowson.co.uk/services/website-care.php'
];
$currentPage = 'services';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container max-w-4xl">
    <h1 class="text-3xl font-bold tracking-tight">Keep your site safe, fast, and up-to-date.</h1>
    <p class="mt-4 text-gray-700">Stop worrying about website maintenance. I'll keep your site secure, backed up, and running smoothly so you can focus on your business.</p>
    
    <div class="mt-8 grid gap-8 lg:grid-cols-2">
      <div>
        <h2 class="text-xl font-semibold text-gray-900 mb-4">What's included</h2>
        <ul class="space-y-3 text-gray-700">
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Managed web hosting included</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Essential updates & security patches</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Daily backups & uptime monitoring</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Fast support when you need it</span>
          </li>
        </ul>
      </div>
      
      <div>
        <h2 class="text-xl font-semibold text-gray-900 mb-4">Why website care matters</h2>
        <ul class="space-y-3 text-gray-700">
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Prevents security breaches & data loss</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Keeps your site fast and reliable</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Maintains search engine rankings</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Peace of mind for your business</span>
          </li>
        </ul>
      </div>
    </div>

    <div class="mt-12">
      <h2 class="text-2xl font-bold text-gray-900 mb-6">Website Care Pricing</h2>
      <div class="grid gap-6 sm:grid-cols-2">
        <div class="pricing-card">
          <h3 class="text-lg font-semibold text-gray-900">Essential Care</h3>
          <p class="mt-1 text-3xl font-bold text-gray-900">£20 / mo</p>
          <p class="text-sm text-gray-500">or £200 / year (save £40)</p>
          <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
            <li>Managed web hosting included</li>
            <li>Essential updates & security patches</li>
            <li>Daily backups & uptime monitoring</li>
            <li>No support included</li>
          </ul>
          <div class="mt-auto pt-6"><a href="/contact/" class="btn-primary w-full">Choose Essential</a></div>
        </div>
        <div class="pricing-card pricing-featured">
          <h3 class="text-lg font-semibold text-gray-900">Plus Care <span class="badge badge-new ml-2">Most popular</span></h3>
          <p class="mt-1 text-3xl font-bold text-gray-900">£40 / mo</p>
          <p class="text-sm text-gray-500">or £400 / year (save £80)</p>
          <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
            <li>Everything in Essential Care</li>
            <li>Fast support when you need it</li>
            <li>Image updates & text changes</li>
            <li>Up to 30 minutes work per month</li>
          </ul>
          <div class="mt-auto pt-6"><a href="/contact/" class="btn-primary w-full">Choose Plus</a></div>
        </div>
      </div>
    </div>

    <div class="mt-12 text-center">
      <h2 class="text-xl font-semibold text-gray-900 mb-4">Ready to protect your website?</h2>
      <p class="text-gray-600 mb-6">Choose a care plan that fits your needs. All plans include managed hosting.</p>
      <div class="flex flex-col sm:flex-row gap-3 justify-center">
        <a class="btn-primary" href="/contact/">Get started</a>
        <a class="btn-secondary" href="/pricing/">See all pricing</a>
      </div>
    </div>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>
