# Yarn Store Frontend - Quick Start Guide

## Getting Started in 5 Minutes

### 1. Run Database Migrations
```bash
cd /Users/neilwiddowson/YS2
php artisan migrate
```

This adds the new SEO and featured fields to your database.

### 2. Verify Assets are Compiled
The assets should already be compiled, but if needed:
```bash
npm run build
```

### 3. Start the Development Server
```bash
php artisan serve
```

Visit: `http://localhost:8000`

---

## Testing the Site

### Pages to Check:
1. **Home** - http://localhost:8000/
2. **Collections** - http://localhost:8000/collections
3. **Search** - Click the search icon in navigation
4. **Basket** - http://localhost:8000/basket
5. **Legal Pages**:
   - http://localhost:8000/terms
   - http://localhost:8000/privacy
   - http://localhost:8000/cookies
6. **Documentation**:
   - http://localhost:8000/about
   - http://localhost:8000/care-guide
   - http://localhost:8000/patterns
7. **Contact** - http://localhost:8000/contact

### SEO Pages:
- **Sitemap** - http://localhost:8000/sitemap.xml
- **Robots** - http://localhost:8000/robots.txt

---

## Adding Sample Data

### Via Admin Panel (if data exists):
1. Log in as admin
2. Go to Seasons and mark some as active
3. Go to Items and toggle "Featured" for 6 products
4. Add images to seasons/products
5. Fill in SEO fields (optional)

### Via Database/Seeder:
Create products and mark them as featured:
```php
// In tinker or a seeder
Item::find(1)->update(['featured' => true]);
Item::find(2)->update(['featured' => true]);
// etc...
```

---

## Testing Key Features

### 1. Basket Functionality
- Go to any product page (you'll need products in database)
- Select a colourway (if available)
- Click "Add to Basket"
- Check basket icon (should show count)
- Visit basket page
- Try adjusting quantities
- Test remove item

### 2. Search
- Click search icon in nav
- Type a search term
- Should see instant results
- Click "View All Results" for full page

### 3. Cookie Consent
- Visit site in incognito mode
- Should see cookie banner at bottom
- Click "Accept All" or "Necessary Only"
- Refresh - banner should not appear again

### 4. Theme (Light/Dark Mode)
- Check in browser with light mode
- Switch OS/browser to dark mode
- Page should automatically adjust colors

---

## Configuration Checklist

### Before Going Live:

- [ ] Update robots.txt with actual domain
- [ ] Update sitemap.xml domain in `SitemapController.php`
- [ ] Configure email settings in `.env` for contact form
- [ ] Set up Google Analytics (optional)
- [ ] Add SSL certificate
- [ ] Test all forms
- [ ] Fill in actual contact information in contact page
- [ ] Review and customize legal pages
- [ ] Add actual business address and phone
- [ ] Test on multiple devices
- [ ] Submit sitemap to Google Search Console

---

## Common Issues & Solutions

### Issue: Homepage shows "No collections available"
**Solution**: Add seasons in admin panel and set them to active

### Issue: Products not showing in categories
**Solution**: Ensure products have `is_active = true` and are linked to categories

### Issue: Basket count not showing
**Solution**: Check browser cookies are enabled, clear cache

### Issue: Search not working
**Solution**: Ensure products exist in database with names/descriptions

### Issue: Styles not loading
**Solution**: Run `npm run build` again and clear browser cache

---

## File Locations Reference

### Frontend Pages
- `/resources/views/frontend/*.blade.php`

### Livewire Components
- `/app/Livewire/*.php`
- `/resources/views/livewire/*.blade.php`

### Styling
- `/resources/sass/custom.scss` (main theme file)

### Routes
- `/routes/web.php`

### Controllers
- `/app/Http/Controllers/FrontendController.php`
- `/app/Http/Controllers/SitemapController.php`

---

## Customization Quick Tips

### Change Primary Color:
1. Edit `/resources/sass/custom.scss`
2. Find `--ys-primary: #2d7a4e;`
3. Change to your color
4. Run `npm run build`

### Update Site Name:
1. Edit `/config/app.php`
2. Change `'name' => 'Yarn Store'`
3. Clear config cache: `php artisan config:clear`

### Modify Navigation:
1. Edit `/resources/views/layouts/frontend.blade.php`
2. Find the navigation section (around line 26)
3. Add/remove menu items

### Update Footer:
1. Edit `/resources/views/layouts/frontend.blade.php`
2. Find the footer section (around line 145)
3. Update links and content

---

## Performance Tips

1. **Enable caching** (production):
   ```bash
   php artisan config:cache
   php artisan route:cache
   php artisan view:cache
   ```

2. **Optimize images** before uploading

3. **Enable Redis** for sessions/cache (optional)

4. **Use CDN** for static assets (production)

---

## Development Workflow

### Making Changes:

1. **Edit Styles**:
   - Edit `/resources/sass/custom.scss`
   - Run `npm run dev` (watches for changes)
   - Or `npm run build` for production

2. **Edit Blade Templates**:
   - Edit files in `/resources/views/`
   - Refresh browser (no build needed)

3. **Edit Livewire Components**:
   - Edit PHP in `/app/Livewire/`
   - Edit view in `/resources/views/livewire/`
   - Refresh browser

4. **Add New Routes**:
   - Edit `/routes/web.php`
   - No cache clear needed in dev mode

---

## Support Resources

- **Laravel Docs**: https://laravel.com/docs
- **Livewire Docs**: https://livewire.laravel.com/docs
- **Bootstrap Docs**: https://getbootstrap.com/docs
- **Implementation Summary**: See `FRONTEND_SUMMARY.md`

---

## Quick Commands

```bash
# Start development
php artisan serve

# Watch assets
npm run dev

# Build for production
npm run build

# Clear all caches
php artisan optimize:clear

# Run migrations
php artisan migrate

# Seed database
php artisan db:seed

# Access tinker
php artisan tinker
```

---

**You're all set!** The frontend is ready to use. Add some products and start testing! 🎉

