<x-app-layout>
    <section class="py-4">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h4 mb-0">Seasons</h1>
                <a href="{{ route('admin.seasons.create') }}" class="btn btn-primary rounded-pill">
                    <i class="bi bi-plus-lg me-1"></i> New Season
                </a>
            </div>

            @if(session('status'))
                <div class="alert alert-primary">{{ session('status') }}</div>
            @endif

            <div class="card shadow-sm">
                <div class="table-responsive">
                    <table class="table align-middle mb-0">
                        <thead>
                            <tr>
                                <th>Code</th>
                                <th>Label</th>
                                <th>Dates</th>
                                <th>Active</th>
                                <th class="text-end">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($seasons as $season)
                                <tr>
                                    <td class="fw-semibold">{{ $season->code }}</td>
                                    <td>{{ $season->label }}</td>
                                    <td>
                                        @if($season->starts_on || $season->ends_on)
                                            {{ $season->starts_on }} – {{ $season->ends_on }}
                                        @else
                                            —
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge {{ $season->is_active ? 'bg-primary' : 'bg-secondary' }}">{{ $season->is_active ? 'Yes' : 'No' }}</span>
                                    </td>
                                    <td class="text-end">
                                        <a href="{{ route('admin.seasons.edit', $season) }}" class="btn btn-sm btn-outline-primary">Edit</a>
                                        <form action="{{ route('admin.seasons.destroy', $season) }}" method="POST" class="d-inline" onsubmit="return confirm('Delete season?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr><td colspan="5" class="text-center text-muted py-4">No seasons yet.</td></tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="card-footer bg-white">{{ $seasons->links() }}</div>
            </div>
        </div>
    </section>
</x-app-layout>


