<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReceiptStatementMatch extends Model
{
    use HasFactory;

    protected $fillable = [
        'receipt_id',
        'statement_line_id',
        'confidence',
        'amount_delta',
        'date_delta_days',
        'method',
        'status',
    ];

    protected $casts = [
        'confidence' => 'decimal:3',
        'amount_delta' => 'decimal:2',
        'date_delta_days' => 'integer',
    ];
}
