@extends('layouts.frontend')

@section('meta_title', 'Contact Us - Yarn Store')
@section('meta_description', 'Get in touch with Yarn Store by Robert Todd Yarn. We\'re here to help with any questions about our products or orders.')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-12">
            <nav class="ys-breadcrumb">
                <a href="{{ route('home') }}">Home</a>
                <span>/</span>
                <span>Contact</span>
            </nav>
        </div>
    </div>

    <div class="row mb-5">
        <div class="col-lg-8 mx-auto text-center">
            <h1 class="display-4 fw-bold mb-3">Get in Touch</h1>
            <p class="lead text-muted">Have a question? We'd love to hear from you. Send us a message and we'll respond as soon as possible.</p>
        </div>
    </div>

    <div class="row g-4">
        <!-- Contact Form -->
        <div class="col-lg-8">
            <div class="ys-card p-4">
                <h2 class="h4 fw-bold mb-4">Send Us a Message</h2>
                
                <form id="contactForm">
                    @csrf
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="name" class="form-label fw-semibold">Name *</label>
                            <input type="text" class="form-control form-control-lg" id="name" name="name" required>
                        </div>
                        <div class="col-md-6">
                            <label for="email" class="form-label fw-semibold">Email Address *</label>
                            <input type="email" class="form-control form-control-lg" id="email" name="email" required>
                        </div>
                        <div class="col-12">
                            <label for="subject" class="form-label fw-semibold">Subject *</label>
                            <input type="text" class="form-control form-control-lg" id="subject" name="subject" required>
                        </div>
                        <div class="col-12">
                            <label for="message" class="form-label fw-semibold">Message *</label>
                            <textarea class="form-control" id="message" name="message" rows="6" required></textarea>
                        </div>
                        <div class="col-12">
                            <button type="submit" class="btn btn-ys-primary btn-lg">
                                Send Message
                            </button>
                        </div>
                    </div>
                </form>

                <div id="successMessage" class="alert alert-success mt-4 d-none">
                    Thank you for your message! We'll get back to you as soon as possible.
                </div>
            </div>
        </div>

        <!-- Contact Information -->
        <div class="col-lg-4">
            <div class="ys-card p-4 mb-4">
                <h2 class="h5 fw-bold mb-4">Contact Information</h2>
                
                <div class="mb-4">
                    <div class="d-flex align-items-start gap-3 mb-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="var(--ys-primary)" viewBox="0 0 16 16" class="flex-shrink-0">
                            <path d="M3.654 1.328a.678.678 0 0 0-1.015-.063L1.605 2.3c-.483.484-.661 1.169-.45 1.77a17.568 17.568 0 0 0 4.168 6.608 17.569 17.569 0 0 0 6.608 4.168c.601.211 1.286.033 1.77-.45l1.034-1.034a.678.678 0 0 0-.063-1.015l-2.307-1.794a.678.678 0 0 0-.58-.122l-2.19.547a1.745 1.745 0 0 1-1.657-.459L5.482 8.062a1.745 1.745 0 0 1-.46-1.657l.548-2.19a.678.678 0 0 0-.122-.58L3.654 1.328zM1.884.511a1.745 1.745 0 0 1 2.612.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.678.678 0 0 0 .178.643l2.457 2.457a.678.678 0 0 0 .644.178l2.189-.547a1.745 1.745 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.634 18.634 0 0 1-7.01-4.42 18.634 18.634 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877L1.885.511z"/>
                        </svg>
                        <div>
                            <p class="fw-semibold mb-1">Phone</p>
                            <p class="text-muted small mb-0">Coming soon</p>
                        </div>
                    </div>

                    <div class="d-flex align-items-start gap-3 mb-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="var(--ys-primary)" viewBox="0 0 16 16" class="flex-shrink-0">
                            <path d="M.05 3.555A2 2 0 0 1 2 2h12a2 2 0 0 1 1.95 1.555L8 8.414.05 3.555ZM0 4.697v7.104l5.803-3.558L0 4.697ZM6.761 8.83l-6.57 4.027A2 2 0 0 0 2 14h12a2 2 0 0 0 1.808-1.144l-6.57-4.027L8 9.586l-1.239-.757Zm3.436-.586L16 11.801V4.697l-5.803 3.546Z"/>
                        </svg>
                        <div>
                            <p class="fw-semibold mb-1">Email</p>
                            <p class="text-muted small mb-0">support@yarnstore.example</p>
                        </div>
                    </div>

                    <div class="d-flex align-items-start gap-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="var(--ys-primary)" viewBox="0 0 16 16" class="flex-shrink-0">
                            <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"/>
                        </svg>
                        <div>
                            <p class="fw-semibold mb-1">Location</p>
                            <p class="text-muted small mb-0">United Kingdom</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="ys-card p-4">
                <h2 class="h5 fw-bold mb-3">Business Hours</h2>
                <div class="small">
                    <div class="d-flex justify-content-between mb-2">
                        <span class="text-muted">Monday - Friday</span>
                        <span class="fw-semibold">9:00 - 17:00</span>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span class="text-muted">Saturday</span>
                        <span class="fw-semibold">10:00 - 14:00</span>
                    </div>
                    <div class="d-flex justify-content-between">
                        <span class="text-muted">Sunday</span>
                        <span class="fw-semibold">Closed</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- FAQ Section -->
    <div class="row mt-5">
        <div class="col-12">
            <h2 class="h3 fw-bold mb-4 text-center">Frequently Asked Questions</h2>
        </div>
    </div>

    <div class="row g-4">
        <div class="col-lg-6">
            <div class="ys-card p-4 h-100">
                <h3 class="h6 fw-bold mb-2">How long does delivery take?</h3>
                <p class="text-muted mb-0 small">
                    We aim to dispatch orders within 2-3 working days. Standard UK delivery typically takes 3-5 working days.
                </p>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="ys-card p-4 h-100">
                <h3 class="h6 fw-bold mb-2">What is your returns policy?</h3>
                <p class="text-muted mb-0 small">
                    You can return items within 14 days of receipt for a full refund. Items must be in original condition.
                </p>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="ys-card p-4 h-100">
                <h3 class="h6 fw-bold mb-2">Do you offer international shipping?</h3>
                <p class="text-muted mb-0 small">
                    Currently, we only ship within the UK. International shipping may be available in the future.
                </p>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="ys-card p-4 h-100">
                <h3 class="h6 fw-bold mb-2">Can I track my order?</h3>
                <p class="text-muted mb-0 small">
                    Yes! Once your order is dispatched, you'll receive a tracking number via email.
                </p>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.getElementById('contactForm').addEventListener('submit', function(e) {
    e.preventDefault();
    // Here you would normally send the form data to your backend
    // For now, we'll just show the success message
    document.getElementById('successMessage').classList.remove('d-none');
    this.reset();
    setTimeout(() => {
        document.getElementById('successMessage').classList.add('d-none');
    }, 5000);
});
</script>
@endpush
@endsection

