import Foundation
import SwiftUI
import UIKit

@MainActor
final class ReceiptCaptureViewModel: ObservableObject {
    // MARK: - Selected images
    @Published var images: [UIImage] = []

    // MARK: - UI State
    @Published var errorMessage: String?
    @Published var infoMessage: String?

    // MARK: - Actions
    func addImage(_ image: UIImage) {
        errorMessage = nil
        infoMessage = nil
        images.append(image)
    }

    func addImages(_ newImages: [UIImage]) {
        errorMessage = nil
        infoMessage = nil
        guard !newImages.isEmpty else { return }
        images.append(contentsOf: newImages)
    }

    func removeImage(at index: Int) {
        guard images.indices.contains(index) else { return }
        images.remove(at: index)
    }

    func clearAll() {
        images.removeAll()
        errorMessage = nil
        infoMessage = nil
    }
}
