<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class StatementTransaction extends Model
{
    protected $fillable = [
        'statement_id',
        'cardholder_name',
        'account_number_masked',
        'transaction_date',
        'posted_date',
        'transaction_time',
        'merchant_name',
        'amount',
        'currency',
        'original_amount',
        'original_currency',
        'conversion_rate',
        'authorisation_code',
        'transaction_id',
        'merchant_category',
        'transaction_type',
        'mcc_description',
        'merchant_city',
        'merchant_state',
        'merchant_postcode',
        'mcc',
        'statement_cycle',
        'has_receipt',
        'user_id',
        'department_id',
        'account_id',
        'is_personal',
        'meta',
    ];

    protected $casts = [
        'transaction_date' => 'date',
        'posted_date' => 'date',
        'transaction_time' => 'datetime:H:i:s',
        'has_receipt' => 'boolean',
        'is_personal' => 'boolean',
        'meta' => 'array',
    ];

    public function statement(): BelongsTo
    {
        return $this->belongsTo(Statement::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function department(): BelongsTo
    {
        return $this->belongsTo(Department::class);
    }

    public function account(): BelongsTo
    {
        return $this->belongsTo(Account::class);
    }

    public function matches(): HasMany
    {
        return $this->hasMany(TransactionMatch::class);
    }
}
