<?php

namespace App\Livewire\Manage;

use Livewire\Component;

class Index extends Component
{
    public string $tab = 'dashboard';
    public ?int $selectedStatementId = null;

    public function setTab(string $tab): void
    {
        $this->tab = $tab;
    }

    public function selectStatement(?int $statementId): void
    {
        $this->selectedStatementId = $statementId;
        $this->tab = 'review';
    }

    public function render()
    {
        return view('livewire.manage.index');
    }
}


