<?php

namespace App\Livewire\Manage;

use Livewire\Component;

class Index extends Component
{
    public string $tab = 'dashboard';
    public ?int $selectedStatementId = null;

    protected string $layout = 'components.layouts.app';

    public function mount(): void
    {
        $this->tab = request()->query('tab', $this->tab);
        $statementId = request()->query('statementId');
        if ($statementId) {
            $this->selectedStatementId = (int) $statementId;
        }
    }

    public function setTab(string $tab): void
    {
        $this->tab = $tab;
    }

    public function selectStatement(?int $statementId): void
    {
        $this->selectedStatementId = $statementId;
        $this->tab = 'review';
    }

    public function render()
    {
        return view('livewire.manage.index')
            ->layout($this->layout, [
                'header' => '<h2 class="font-semibold text-xl leading-tight">Manage</h2>',
            ]);
    }
}


