const db = require('./src/db-multi-tenant');

async function checkStripeSave() {
  try {
    console.log('Checking if Stripe Price ID was saved...\n');
    
    const result = await db.pool.query(`
      SELECT id, tier_key, tier_name, stripe_price_id, stripe_product_id 
      FROM subscription_tiers 
      WHERE id = 1;
    `);
    
    if (result.rows.length > 0) {
      const tier = result.rows[0];
      console.log(`Tier: ${tier.tier_name} (${tier.tier_key})`);
      console.log(`  ID: ${tier.id}`);
      console.log(`  Stripe Price ID: ${tier.stripe_price_id || '(not set)'}`);
      console.log(`  Stripe Product ID: ${tier.stripe_product_id || '(not set)'}`);
      
      if (tier.stripe_price_id === 'price_test_starter_123') {
        console.log('\n✅ SUCCESS! The test value was saved correctly!');
      } else {
        console.log('\n❌ The test value was NOT saved.');
      }
    } else {
      console.log('❌ No tier found with ID 1');
    }
    
    await db.pool.end();
    process.exit(0);
  } catch (error) {
    console.error('❌ Error:', error.message);
    process.exit(1);
  }
}

checkStripeSave();

