<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('colourways', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->foreignId('item_id')->constrained()->cascadeOnDelete();
            $table->string('name', 150);
            $table->string('colour_code', 50);
            $table->string('image_path', 255)->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            // Indexes
            $table->index('item_id');
            $table->index(['item_id', 'sort_order']);
            
            // Unique constraints
            $table->unique(['item_id', 'colour_code']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('colourways');
    }
};
