<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Season;
use App\Models\Category;
use App\Models\Item;
use App\Models\Colourway;
use App\Models\Customer;
use App\Models\Address;
use App\Models\Order;
use App\Models\OrderLine;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // User::factory(10)->create();

        User::factory()->create([
            'name' => 'Test User',
            'email' => 'test@example.com',
        ]);

        // Create sample seasons
        $aw25 = Season::create([
            'code' => 'AW25',
            'half' => 'AW',
            'year' => 2025,
            'label' => 'Autumn/Winter 2025',
            'starts_on' => '2025-09-01',
            'ends_on' => '2026-02-28',
            'is_active' => true,
        ]);

        $ss26 = Season::create([
            'code' => 'SS26',
            'half' => 'SS',
            'year' => 2026,
            'label' => 'Spring/Summer 2026',
            'starts_on' => '2026-03-01',
            'ends_on' => '2026-08-31',
            'is_active' => true,
        ]);

        // Create sample categories
        $knitwear = Category::create([
            'name' => 'Knitwear',
            'slug' => 'knitwear',
            'description' => 'Hand-knitted and machine-knitted garments',
            'sort_order' => 1,
        ]);

        $accessories = Category::create([
            'name' => 'Accessories',
            'slug' => 'accessories',
            'description' => 'Scarves, hats, and other accessories',
            'sort_order' => 2,
        ]);

        $yarns = Category::create([
            'name' => 'Yarns',
            'slug' => 'yarns',
            'description' => 'High-quality yarns for knitting and crochet',
            'sort_order' => 3,
        ]);

        // Create sample items
        $sweater = Item::create([
            'category_id' => $knitwear->id,
            'season_id' => $aw25->id,
            'name' => 'Classic Aran Sweater',
            'slug' => 'classic-aran-sweater',
            'sku' => 'SW-ARAN-001',
            'description' => 'Traditional Aran pattern sweater in natural wool',
            'colour_grid_columns' => 4,
            'has_colourways' => true,
            'attributes' => [
                'material' => '100% Wool',
                'weight' => 'Medium',
                'pattern' => 'Aran',
            ],
            'is_active' => true,
        ]);

        $scarf = Item::create([
            'category_id' => $accessories->id,
            'season_id' => $aw25->id,
            'name' => 'Cashmere Scarf',
            'slug' => 'cashmere-scarf',
            'sku' => 'SC-CASH-001',
            'description' => 'Luxurious cashmere scarf',
            'colour_grid_columns' => 3,
            'has_colourways' => true,
            'attributes' => [
                'material' => '100% Cashmere',
                'weight' => 'Light',
                'dimensions' => '180cm x 30cm',
            ],
            'is_active' => true,
        ]);

        $yarn = Item::create([
            'category_id' => $yarns->id,
            'season_id' => null,
            'name' => 'Merino Wool Yarn',
            'slug' => 'merino-wool-yarn',
            'sku' => 'YN-MERINO-001',
            'description' => 'Premium merino wool yarn for knitting',
            'colour_grid_columns' => 6,
            'has_colourways' => true,
            'attributes' => [
                'material' => '100% Merino Wool',
                'weight' => 'DK',
                'yardage' => '200m per 100g',
            ],
            'is_active' => true,
        ]);

        // Create sample colourways
        Colourway::create([
            'item_id' => $sweater->id,
            'name' => 'Natural Cream',
            'colour_code' => 'NC01',
            'sort_order' => 1,
            'is_active' => true,
        ]);

        Colourway::create([
            'item_id' => $sweater->id,
            'name' => 'Charcoal Grey',
            'colour_code' => 'CG02',
            'sort_order' => 2,
            'is_active' => true,
        ]);

        Colourway::create([
            'item_id' => $scarf->id,
            'name' => 'Ivory',
            'colour_code' => 'IV01',
            'sort_order' => 1,
            'is_active' => true,
        ]);

        Colourway::create([
            'item_id' => $scarf->id,
            'name' => 'Navy Blue',
            'colour_code' => 'NB01',
            'sort_order' => 2,
            'is_active' => true,
        ]);

        Colourway::create([
            'item_id' => $yarn->id,
            'name' => 'Natural White',
            'colour_code' => 'NW01',
            'sort_order' => 1,
            'is_active' => true,
        ]);

        Colourway::create([
            'item_id' => $yarn->id,
            'name' => 'Sky Blue',
            'colour_code' => 'SB01',
            'sort_order' => 2,
            'is_active' => true,
        ]);

        // Create sample customer
        $customer = Customer::create([
            'first_name' => 'John',
            'last_name' => 'Doe',
            'email' => 'john.doe@example.com',
            'phone' => '+44 20 1234 5678',
            'notes' => 'Regular customer, prefers natural fibres',
            'marketing_opt_in' => true,
        ]);

        // Create sample address
        Address::create([
            'customer_id' => $customer->id,
            'label' => 'Home',
            'contact_name' => 'John Doe',
            'line1' => '123 Main Street',
            'line2' => 'Flat 4B',
            'city' => 'London',
            'region' => 'Greater London',
            'postcode' => 'SW1A 1AA',
            'country_code' => 'GB',
            'phone' => '+44 20 1234 5678',
            'is_default_billing' => true,
            'is_default_shipping' => true,
        ]);

        // Create sample order
        $order = Order::create([
            'order_number' => 'ORD-2025-001',
            'customer_id' => $customer->id,
            'status' => 'draft',
            'notes' => 'Sample order for testing',
            'currency' => 'GBP',
            'totals_estimated_minor' => 15000, // £150.00
            'totals_final_minor' => 0,
            'bill_name' => 'John Doe',
            'bill_line1' => '123 Main Street',
            'bill_line2' => 'Flat 4B',
            'bill_city' => 'London',
            'bill_region' => 'Greater London',
            'bill_postcode' => 'SW1A 1AA',
            'bill_country_code' => 'GB',
            'ship_name' => 'John Doe',
            'ship_line1' => '123 Main Street',
            'ship_line2' => 'Flat 4B',
            'ship_city' => 'London',
            'ship_region' => 'Greater London',
            'ship_postcode' => 'SW1A 1AA',
            'ship_country_code' => 'GB',
        ]);

        // Create sample order line
        OrderLine::create([
            'order_id' => $order->id,
            'item_id' => $sweater->id,
            'colourway_id' => $sweater->colourways->first()->id,
            'quantity' => 1,
            'estimated_weight_g' => 500,
            'price_estimated_minor' => 15000, // £150.00
            'price_final_minor' => 0,
            'attributes' => [
                'size' => 'M',
                'custom_notes' => 'Standard fit',
            ],
        ]);
    }
}
