<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Season;
use App\Models\Category;
use App\Models\Item;
use App\Models\Colourway;
use App\Models\Customer;
use App\Models\Address;
use App\Models\Order;
use App\Models\OrderLine;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // User::factory(10)->create();

        User::factory()->create([
            'name' => 'Test User',
            'email' => 'test@example.com',
        ]);

        // Create seasons
        $aw25 = Season::create([
            'code' => 'AW25',
            'half' => 'AW',
            'year' => 2025,
            'label' => 'Autumn/Winter 2025',
            'description' => 'Experience the warmth and luxury of our Autumn/Winter collection featuring rich, deep tones and sumptuous fibres perfect for cozy winter garments. Our AW25 range includes premium merino wool, cashmere blends, and silk combinations that offer both comfort and elegance.',
            'starts_on' => '2025-08-01',
            'ends_on' => '2026-01-31',
            'is_active' => true,
        ]);

        $ss26 = Season::create([
            'code' => 'SS26',
            'half' => 'SS',
            'year' => 2026,
            'label' => 'Spring/Summer 2026',
            'description' => 'Discover the lightness and vibrancy of our Spring/Summer collection with fresh, airy fibres and bright, inspiring colours. Our SS26 range features lightweight merino, breathable silk blends, and cotton combinations perfect for warm weather comfort.',
            'starts_on' => '2026-02-01',
            'ends_on' => '2026-07-31',
            'is_active' => true,
        ]);

        // Create categories
        $cashmere = Category::create([
            'name' => 'Cashmere',
            'slug' => 'cashmere',
            'description' => 'Luxury cashmere yarns known for their exceptional softness and warmth. Perfect for premium garments and accessories.',
            'sort_order' => 1,
        ]);

        $lambswool = Category::create([
            'name' => 'Lambswool',
            'slug' => 'lambswool',
            'description' => 'Soft and warm lambswool yarns offering excellent insulation and comfort. Ideal for winter wear.',
            'sort_order' => 2,
        ]);

        $extrafineMerino = Category::create([
            'name' => 'Extrafine Merino',
            'slug' => 'extrafine-merino',
            'description' => 'Ultra-fine merino wool yarns with exceptional softness and breathability. Perfect for next-to-skin garments.',
            'sort_order' => 3,
        ]);

        $cashmereWool = Category::create([
            'name' => 'Cashmere Wool',
            'slug' => 'cashmere-wool',
            'description' => 'Premium blends of cashmere and wool offering the best of both worlds - luxury and durability.',
            'sort_order' => 4,
        ]);

        $fancyBoucle = Category::create([
            'name' => 'Fancy Boucle',
            'slug' => 'fancy-boucle',
            'description' => 'Textured boucle yarns with unique loops and curls. Perfect for adding visual interest to your projects.',
            'sort_order' => 5,
        ]);

        $silk = Category::create([
            'name' => 'Silk',
            'slug' => 'silk',
            'description' => 'Luxurious silk yarns with natural sheen and drape. Ideal for elegant, lightweight garments.',
            'sort_order' => 6,
        ]);

        $cotton = Category::create([
            'name' => 'Cotton',
            'slug' => 'cotton',
            'description' => 'Natural cotton yarns offering breathability and comfort. Perfect for warm weather and everyday wear.',
            'sort_order' => 7,
        ]);

        // Create sample items
        $sweater = Item::create([
            'category_id' => $cashmere->id,
            'season_id' => $aw25->id,
            'name' => 'Classic Aran Sweater',
            'slug' => 'classic-aran-sweater',
            'sku' => 'SW-ARAN-001',
            'description' => 'Traditional Aran pattern sweater in natural wool',
            'colour_grid_columns' => 3,
            'has_colourways' => true,
            'attributes' => ['weight' => 'Aran', 'gauge' => '18sts/4in'],
            'is_active' => true,
        ]);

        $scarf = Item::create([
            'category_id' => $cashmere->id,
            'season_id' => $aw25->id,
            'name' => 'Cashmere Scarf',
            'slug' => 'cashmere-scarf',
            'sku' => 'SC-CASH-001',
            'description' => 'Luxurious cashmere scarf with elegant drape',
            'colour_grid_columns' => 4,
            'has_colourways' => true,
            'attributes' => ['weight' => 'DK', 'gauge' => '22sts/4in'],
            'is_active' => true,
        ]);

        $yarn = Item::create([
            'category_id' => $extrafineMerino->id,
            'season_id' => null,
            'name' => 'Merino Wool Yarn',
            'slug' => 'merino-wool-yarn',
            'sku' => 'YN-MER-001',
            'description' => 'Ultra-soft merino wool yarn for next-to-skin wear',
            'colour_grid_columns' => 5,
            'has_colourways' => true,
            'attributes' => ['weight' => '4ply', 'gauge' => '28sts/4in'],
            'is_active' => true,
        ]);

        // Add more items for each category
        Item::create([
            'category_id' => $lambswool->id,
            'season_id' => $aw25->id,
            'name' => 'Lambswool Chunky',
            'slug' => 'lambswool-chunky',
            'sku' => 'YN-LAM-CHUNK-001',
            'description' => 'Warm and cozy chunky lambswool yarn',
            'colour_grid_columns' => 4,
            'has_colourways' => true,
            'attributes' => ['weight' => 'Chunky', 'gauge' => '16sts/4in'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $lambswool->id,
            'season_id' => $aw25->id,
            'name' => 'Lambswool DK',
            'slug' => 'lambswool-dk',
            'sku' => 'YN-LAM-DK-001',
            'description' => 'Versatile DK weight lambswool for all projects',
            'colour_grid_columns' => 5,
            'has_colourways' => true,
            'attributes' => ['weight' => 'DK', 'gauge' => '22sts/4in'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $extrafineMerino->id,
            'season_id' => $ss26->id,
            'name' => 'Extrafine Merino 4ply',
            'slug' => 'extrafine-merino-4ply',
            'sku' => 'YN-EFM-4PLY-001',
            'description' => 'Ultra-fine merino perfect for lightweight garments',
            'colour_grid_columns' => 6,
            'has_colourways' => true,
            'attributes' => ['weight' => '4ply', 'gauge' => '28sts/4in'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $extrafineMerino->id,
            'season_id' => $ss26->id,
            'name' => 'Extrafine Merino Lace',
            'slug' => 'extrafine-merino-lace',
            'sku' => 'YN-EFM-LACE-001',
            'description' => 'Delicate lace weight merino for shawls and wraps',
            'colour_grid_columns' => 4,
            'has_colourways' => true,
            'attributes' => ['weight' => 'Lace', 'gauge' => '32sts/4in'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $cashmereWool->id,
            'season_id' => $aw25->id,
            'name' => 'Cashmere Wool Blend',
            'slug' => 'cashmere-wool-blend',
            'sku' => 'YN-CW-BLEND-001',
            'description' => 'Premium blend offering luxury and durability',
            'colour_grid_columns' => 4,
            'has_colourways' => true,
            'attributes' => ['weight' => 'Aran', 'gauge' => '18sts/4in'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $cashmereWool->id,
            'season_id' => $aw25->id,
            'name' => 'Cashmere Wool DK',
            'slug' => 'cashmere-wool-dk',
            'sku' => 'YN-CW-DK-001',
            'description' => 'Versatile DK weight cashmere wool blend',
            'colour_grid_columns' => 5,
            'has_colourways' => true,
            'attributes' => ['weight' => 'DK', 'gauge' => '22sts/4in'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $fancyBoucle->id,
            'season_id' => $ss26->id,
            'name' => 'Fancy Boucle Chunky',
            'slug' => 'fancy-boucle-chunky',
            'sku' => 'YN-FB-CHUNK-001',
            'description' => 'Textured chunky boucle for statement pieces',
            'colour_grid_columns' => 3,
            'has_colourways' => true,
            'attributes' => ['weight' => 'Chunky', 'gauge' => '16sts/4in'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $fancyBoucle->id,
            'season_id' => $ss26->id,
            'name' => 'Fancy Boucle DK',
            'slug' => 'fancy-boucle-dk',
            'sku' => 'YN-FB-DK-001',
            'description' => 'Versatile DK boucle for textured projects',
            'colour_grid_columns' => 4,
            'has_colourways' => true,
            'attributes' => ['weight' => 'DK', 'gauge' => '22sts/4in'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $silk->id,
            'season_id' => $ss26->id,
            'name' => 'Pure Silk Lace',
            'slug' => 'pure-silk-lace',
            'sku' => 'YN-SILK-LACE-001',
            'description' => 'Luxurious silk lace weight yarn',
            'colour_grid_columns' => 4,
            'has_colourways' => true,
            'attributes' => ['weight' => 'Lace', 'gauge' => '32sts/4in'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $silk->id,
            'season_id' => $ss26->id,
            'name' => 'Silk DK',
            'slug' => 'silk-dk',
            'sku' => 'YN-SILK-DK-001',
            'description' => 'Elegant DK weight silk for summer garments',
            'colour_grid_columns' => 5,
            'has_colourways' => true,
            'attributes' => ['weight' => 'DK', 'gauge' => '22sts/4in'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $cotton->id,
            'season_id' => $ss26->id,
            'name' => 'Organic Cotton DK',
            'slug' => 'organic-cotton-dk',
            'sku' => 'YN-COT-DK-001',
            'description' => 'Natural organic cotton for warm weather',
            'colour_grid_columns' => 6,
            'has_colourways' => true,
            'attributes' => ['weight' => 'DK', 'gauge' => '22sts/4in'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $cotton->id,
            'season_id' => $ss26->id,
            'name' => 'Cotton 4ply',
            'slug' => 'cotton-4ply',
            'sku' => 'YN-COT-4PLY-001',
            'description' => 'Lightweight cotton perfect for summer tops',
            'colour_grid_columns' => 5,
            'has_colourways' => true,
            'attributes' => ['weight' => '4ply', 'gauge' => '28sts/4in'],
            'is_active' => true,
        ]);

        // Create sample colourways
        Colourway::create([
            'item_id' => $sweater->id,
            'name' => 'Natural Cream',
            'colour_code' => 'NC01',
            'sort_order' => 1,
            'is_active' => true,
        ]);

        Colourway::create([
            'item_id' => $sweater->id,
            'name' => 'Charcoal Grey',
            'colour_code' => 'CG02',
            'sort_order' => 2,
            'is_active' => true,
        ]);

        Colourway::create([
            'item_id' => $scarf->id,
            'name' => 'Ivory',
            'colour_code' => 'IV01',
            'sort_order' => 1,
            'is_active' => true,
        ]);

        Colourway::create([
            'item_id' => $scarf->id,
            'name' => 'Navy Blue',
            'colour_code' => 'NB01',
            'sort_order' => 2,
            'is_active' => true,
        ]);

        Colourway::create([
            'item_id' => $yarn->id,
            'name' => 'Natural White',
            'colour_code' => 'NW01',
            'sort_order' => 1,
            'is_active' => true,
        ]);

        Colourway::create([
            'item_id' => $yarn->id,
            'name' => 'Sky Blue',
            'colour_code' => 'SB01',
            'sort_order' => 2,
            'is_active' => true,
        ]);

        // Create sample customer
        $customer = Customer::create([
            'first_name' => 'John',
            'last_name' => 'Doe',
            'email' => 'john.doe@example.com',
            'phone' => '+44 20 1234 5678',
            'notes' => 'Regular customer, prefers natural fibres',
            'marketing_opt_in' => true,
        ]);

        // Create sample address
        Address::create([
            'customer_id' => $customer->id,
            'label' => 'Home',
            'contact_name' => 'John Doe',
            'line1' => '123 Main Street',
            'line2' => 'Flat 4B',
            'city' => 'London',
            'region' => 'Greater London',
            'postcode' => 'SW1A 1AA',
            'country_code' => 'GB',
            'phone' => '+44 20 1234 5678',
            'is_default_billing' => true,
            'is_default_shipping' => true,
        ]);

        // Create sample order
        $order = Order::create([
            'order_number' => 'ORD-2025-001',
            'customer_id' => $customer->id,
            'status' => 'draft',
            'notes' => 'Sample order for testing',
            'currency' => 'GBP',
            'totals_estimated_minor' => 15000, // £150.00
            'totals_final_minor' => 0,
            'bill_name' => 'John Doe',
            'bill_line1' => '123 Main Street',
            'bill_line2' => 'Flat 4B',
            'bill_city' => 'London',
            'bill_region' => 'Greater London',
            'bill_postcode' => 'SW1A 1AA',
            'bill_country_code' => 'GB',
            'ship_name' => 'John Doe',
            'ship_line1' => '123 Main Street',
            'ship_line2' => 'Flat 4B',
            'ship_city' => 'London',
            'ship_region' => 'Greater London',
            'ship_postcode' => 'SW1A 1AA',
            'ship_country_code' => 'GB',
        ]);

        // Create sample order line
        OrderLine::create([
            'order_id' => $order->id,
            'item_id' => $sweater->id,
            'colourway_id' => $sweater->colourways->first()->id,
            'quantity' => 1,
            'estimated_weight_g' => 500,
            'price_estimated_minor' => 15000, // £150.00
            'price_final_minor' => 0,
            'attributes' => [
                'size' => 'M',
                'custom_notes' => 'Standard fit',
            ],
        ]);
    }
}
