<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Season;
use App\Models\Category;
use App\Models\Item;
use App\Models\Colourway;
use App\Models\Customer;
use App\Models\Address;
use App\Models\Order;
use App\Models\OrderLine;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // User::factory(10)->create();

        User::firstOrCreate([
            'email' => 'test@example.com',
        ], [
            'name' => 'Test User',
        ]);

        // Create seasons
        $aw25 = Season::create([
            'code' => 'AW25',
            'half' => 'AW',
            'year' => 2025,
            'label' => 'Autumn/Winter 2025',
            'description' => 'Experience the warmth and luxury of our Autumn/Winter collection featuring rich, deep tones and sumptuous fibres perfect for cozy winter garments. Our AW25 range includes premium merino wool, cashmere blends, and silk combinations that offer both comfort and elegance.',
            'starts_on' => '2025-08-01',
            'ends_on' => '2026-01-31',
            'is_active' => true,
        ]);

        $ss26 = Season::create([
            'code' => 'SS26',
            'half' => 'SS',
            'year' => 2026,
            'label' => 'Spring/Summer 2026',
            'description' => 'Discover the lightness and vibrancy of our Spring/Summer collection with fresh, airy fibres and bright, inspiring colours. Our SS26 range features lightweight merino, breathable silk blends, and cotton combinations perfect for warm weather comfort.',
            'starts_on' => '2026-02-01',
            'ends_on' => '2026-07-31',
            'is_active' => true,
        ]);

        // Create categories
        $cashmere = Category::create([
            'name' => 'Cashmere',
            'slug' => 'cashmere',
            'description' => 'Luxury cashmere yarns known for their exceptional softness and warmth. Perfect for premium garments and accessories.',
            'sort_order' => 1,
        ]);

        $lambswool = Category::create([
            'name' => 'Lambswool',
            'slug' => 'lambswool',
            'description' => 'Soft and warm lambswool yarns offering excellent insulation and comfort. Ideal for winter wear.',
            'sort_order' => 2,
        ]);

        $extrafineMerino = Category::create([
            'name' => 'Extrafine Merino',
            'slug' => 'extrafine-merino',
            'description' => 'Ultra-fine merino wool yarns with exceptional softness and breathability. Perfect for next-to-skin garments.',
            'sort_order' => 3,
        ]);

        $cashmereWool = Category::create([
            'name' => 'Cashmere Wool',
            'slug' => 'cashmere-wool',
            'description' => 'Premium blends of cashmere and wool offering the best of both worlds - luxury and durability.',
            'sort_order' => 4,
        ]);

        $fancyBoucle = Category::create([
            'name' => 'Fancy Boucle',
            'slug' => 'fancy-boucle',
            'description' => 'Textured boucle yarns with unique loops and curls. Perfect for adding visual interest to your projects.',
            'sort_order' => 5,
        ]);

        $silk = Category::create([
            'name' => 'Silk',
            'slug' => 'silk',
            'description' => 'Luxurious silk yarns with natural sheen and drape. Ideal for elegant, lightweight garments.',
            'sort_order' => 6,
        ]);

        $cotton = Category::create([
            'name' => 'Cotton',
            'slug' => 'cotton',
            'description' => 'Natural cotton yarns offering breathability and comfort. Perfect for warm weather and everyday wear.',
            'sort_order' => 7,
        ]);

        // Create sample items - All yarns, no knitted products
        Item::create([
            'category_id' => $cashmere->id,
            'season_id' => $aw25->id,
            'name' => 'Cashmere 2/28',
            'slug' => 'cashmere-2-28',
            'sku' => 'YN-CASH-2-28-001',
            'description' => 'Premium 2/28 cashmere yarn offering exceptional softness and luxury',
            'colour_grid_columns' => 5,
            'has_colourways' => true,
            'attributes' => ['weight' => '2/28', 'gauge' => '28sts/4in', 'type' => 'Cashmere'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $lambswool->id,
            'season_id' => $aw25->id,
            'name' => 'Supergeelong 2/15',
            'slug' => 'supergeelong-2-15',
            'sku' => 'YN-LAM-SG-2-15-001',
            'description' => 'Supergeelong lambswool yarn in 2/15 weight for warm winter projects',
            'colour_grid_columns' => 4,
            'has_colourways' => true,
            'attributes' => ['weight' => '2/15', 'gauge' => '15sts/4in', 'type' => 'Lambswool'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $lambswool->id,
            'season_id' => $aw25->id,
            'name' => 'Supergeelong 1/15',
            'slug' => 'supergeelong-1-15',
            'sku' => 'YN-LAM-SG-1-15-001',
            'description' => 'Supergeelong lambswool yarn in 1/15 weight for fine winter garments',
            'colour_grid_columns' => 4,
            'has_colourways' => true,
            'attributes' => ['weight' => '1/15', 'gauge' => '15sts/4in', 'type' => 'Lambswool'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $lambswool->id,
            'season_id' => $aw25->id,
            'name' => 'Kent 2/18',
            'slug' => 'kent-2-18',
            'sku' => 'YN-LAM-KENT-2-18-001',
            'description' => 'Kent lambswool yarn in 2/18 weight for versatile winter projects',
            'colour_grid_columns' => 5,
            'has_colourways' => true,
            'attributes' => ['weight' => '2/18', 'gauge' => '18sts/4in', 'type' => 'Lambswool'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $extrafineMerino->id,
            'season_id' => $ss26->id,
            'name' => 'Cashwool 2/30 Mouline',
            'slug' => 'cashwool-2-30-mouline',
            'sku' => 'YN-EFM-CW-2-30-M-001',
            'description' => 'Cashwool 2/30 Mouline extrafine merino for lightweight summer garments',
            'colour_grid_columns' => 6,
            'has_colourways' => true,
            'attributes' => ['weight' => '2/30', 'gauge' => '30sts/4in', 'type' => 'Extrafine Merino'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $extrafineMerino->id,
            'season_id' => $ss26->id,
            'name' => 'Cashwool 2/30',
            'slug' => 'cashwool-2-30',
            'sku' => 'YN-EFM-CW-2-30-001',
            'description' => 'Cashwool 2/30 extrafine merino for breathable summer wear',
            'colour_grid_columns' => 6,
            'has_colourways' => true,
            'attributes' => ['weight' => '2/30', 'gauge' => '30sts/4in', 'type' => 'Extrafine Merino'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $cashmereWool->id,
            'season_id' => $aw25->id,
            'name' => 'Baba 2/15',
            'slug' => 'baba-2-15',
            'sku' => 'YN-CW-BABA-2-15-001',
            'description' => 'Baba 2/15 cashmere wool blend offering luxury and durability',
            'colour_grid_columns' => 4,
            'has_colourways' => true,
            'attributes' => ['weight' => '2/15', 'gauge' => '15sts/4in', 'type' => 'Cashmere Wool'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $cashmereWool->id,
            'season_id' => $aw25->id,
            'name' => 'Baba 1/15',
            'slug' => 'baba-1-15',
            'sku' => 'YN-CW-BABA-1-15-001',
            'description' => 'Baba 1/15 cashmere wool blend for fine winter garments',
            'colour_grid_columns' => 4,
            'has_colourways' => true,
            'attributes' => ['weight' => '1/15', 'gauge' => '15sts/4in', 'type' => 'Cashmere Wool'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $fancyBoucle->id,
            'season_id' => $ss26->id,
            'name' => 'Mousse 14000',
            'slug' => 'mousse-14000',
            'sku' => 'YN-FB-MOUSSE-14000-001',
            'description' => 'Mousse 14000 fancy boucle yarn for textured statement pieces',
            'colour_grid_columns' => 3,
            'has_colourways' => true,
            'attributes' => ['weight' => '14000', 'gauge' => 'Custom', 'type' => 'Fancy Boucle'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $fancyBoucle->id,
            'season_id' => $ss26->id,
            'name' => 'Mousse 8000',
            'slug' => 'mousse-8000',
            'sku' => 'YN-FB-MOUSSE-8000-001',
            'description' => 'Mousse 8000 fancy boucle yarn for medium textured projects',
            'colour_grid_columns' => 4,
            'has_colourways' => true,
            'attributes' => ['weight' => '8000', 'gauge' => 'Custom', 'type' => 'Fancy Boucle'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $fancyBoucle->id,
            'season_id' => $ss26->id,
            'name' => 'Alpafur 1600',
            'slug' => 'alpafur-1600',
            'sku' => 'YN-FB-ALPAFUR-1600-001',
            'description' => 'Alpafur 1600 fancy boucle yarn for fine textured details',
            'colour_grid_columns' => 4,
            'has_colourways' => true,
            'attributes' => ['weight' => '1600', 'gauge' => 'Custom', 'type' => 'Fancy Boucle'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $silk->id,
            'season_id' => $ss26->id,
            'name' => 'Silk 2/120x2',
            'slug' => 'silk-2-120x2',
            'sku' => 'YN-SILK-2-120X2-001',
            'description' => 'Silk 2/120x2 yarn for luxurious lightweight summer garments',
            'colour_grid_columns' => 4,
            'has_colourways' => true,
            'attributes' => ['weight' => '2/120x2', 'gauge' => '120sts/4in', 'type' => 'Silk'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $cotton->id,
            'season_id' => $ss26->id,
            'name' => 'Dakota',
            'slug' => 'dakota',
            'sku' => 'YN-COT-DAKOTA-001',
            'description' => 'Dakota cotton yarn for comfortable warm weather wear',
            'colour_grid_columns' => 5,
            'has_colourways' => true,
            'attributes' => ['weight' => 'DK', 'gauge' => '22sts/4in', 'type' => 'Cotton'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $cotton->id,
            'season_id' => $ss26->id,
            'name' => 'Pima 14',
            'slug' => 'pima-14',
            'sku' => 'YN-COT-PIMA-14-001',
            'description' => 'Pima 14 cotton yarn for premium summer garments',
            'colour_grid_columns' => 5,
            'has_colourways' => true,
            'attributes' => ['weight' => '14', 'gauge' => 'Custom', 'type' => 'Cotton'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $cotton->id,
            'season_id' => $ss26->id,
            'name' => 'Pima 12',
            'slug' => 'pima-12',
            'sku' => 'YN-COT-PIMA-12-001',
            'description' => 'Pima 12 cotton yarn for fine summer projects',
            'colour_grid_columns' => 5,
            'has_colourways' => true,
            'attributes' => ['weight' => '12', 'gauge' => 'Custom', 'type' => 'Cotton'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $cotton->id,
            'season_id' => $ss26->id,
            'name' => 'Pima 14 Melange 2/50',
            'slug' => 'pima-14-melange-2-50',
            'sku' => 'YN-COT-PIMA-14-MEL-2-50-001',
            'description' => 'Pima 14 Melange 2/50 cotton yarn for textured summer garments',
            'colour_grid_columns' => 4,
            'has_colourways' => true,
            'attributes' => ['weight' => '2/50', 'gauge' => 'Custom', 'type' => 'Cotton Melange'],
            'is_active' => true,
        ]);

        Item::create([
            'category_id' => $cotton->id,
            'season_id' => $ss26->id,
            'name' => 'Pima 12 Melange 3/50',
            'slug' => 'pima-12-melange-3-50',
            'sku' => 'YN-COT-PIMA-12-MEL-3-50-001',
            'description' => 'Pima 12 Melange 3/50 cotton yarn for fine textured summer projects',
            'colour_grid_columns' => 4,
            'has_colourways' => true,
            'attributes' => ['weight' => '3/50', 'gauge' => 'Custom', 'type' => 'Cotton Melange'],
            'is_active' => true,
        ]);

        // Create sample colourways
        $cashmereItem = Item::where('category_id', $cashmere->id)->first();
        $lambswoolItem = Item::where('category_id', $lambswool->id)->first();
        $extrafineMerinoItem = Item::where('category_id', $extrafineMerino->id)->first();
        
        Colourway::create([
            'item_id' => $cashmereItem->id,
            'name' => 'Natural Cream',
            'colour_code' => 'NC001',
            'image_path' => null,
            'sort_order' => 1,
            'is_active' => true,
        ]);

        Colourway::create([
            'item_id' => $cashmereItem->id,
            'name' => 'Charcoal Grey',
            'colour_code' => 'CG002',
            'image_path' => null,
            'sort_order' => 2,
            'is_active' => true,
        ]);

        Colourway::create([
            'item_id' => $cashmereItem->id,
            'name' => 'Navy Blue',
            'colour_code' => 'NB003',
            'image_path' => null,
            'sort_order' => 3,
            'is_active' => true,
        ]);

        Colourway::create([
            'item_id' => $lambswoolItem->id,
            'name' => 'Camel',
            'colour_code' => 'CAM001',
            'image_path' => null,
            'sort_order' => 1,
            'is_active' => true,
        ]);

        Colourway::create([
            'item_id' => $lambswoolItem->id,
            'name' => 'Rose Pink',
            'colour_code' => 'RP002',
            'image_path' => null,
            'sort_order' => 2,
            'is_active' => true,
        ]);

        Colourway::create([
            'item_id' => $lambswoolItem->id,
            'name' => 'Forest Green',
            'colour_code' => 'FG003',
            'image_path' => null,
            'sort_order' => 3,
            'is_active' => true,
        ]);

        Colourway::create([
            'item_id' => $extrafineMerinoItem->id,
            'name' => 'Pearl White',
            'colour_code' => 'PW001',
            'image_path' => null,
            'sort_order' => 1,
            'is_active' => true,
        ]);

        Colourway::create([
            'item_id' => $extrafineMerinoItem->id,
            'name' => 'Sky Blue',
            'colour_code' => 'SB002',
            'image_path' => null,
            'sort_order' => 2,
            'is_active' => true,
        ]);

        Colourway::create([
            'item_id' => $extrafineMerinoItem->id,
            'name' => 'Lavender',
            'colour_code' => 'LAV003',
            'image_path' => null,
            'sort_order' => 3,
            'is_active' => true,
        ]);

        // Create sample customer
        $customer = Customer::create([
            'first_name' => 'John',
            'last_name' => 'Doe',
            'email' => 'john.doe@example.com',
            'phone' => '+44 20 1234 5678',
            'notes' => 'Regular customer, prefers natural fibres',
            'marketing_opt_in' => true,
        ]);

        // Create sample address
        Address::create([
            'customer_id' => $customer->id,
            'label' => 'Home',
            'contact_name' => 'John Doe',
            'line1' => '123 Main Street',
            'line2' => 'Flat 4B',
            'city' => 'London',
            'region' => 'Greater London',
            'postcode' => 'SW1A 1AA',
            'country_code' => 'GB',
            'phone' => '+44 20 1234 5678',
            'is_default_billing' => true,
            'is_default_shipping' => true,
        ]);

        // Create sample order
        $order = Order::create([
            'order_number' => 'ORD-2025-001',
            'customer_id' => $customer->id,
            'status' => 'draft',
            'notes' => 'Sample order for testing',
            'currency' => 'GBP',
            'totals_estimated_minor' => 15000, // £150.00
            'totals_final_minor' => 0,
            'bill_name' => 'John Doe',
            'bill_line1' => '123 Main Street',
            'bill_line2' => 'Flat 4B',
            'bill_city' => 'London',
            'bill_region' => 'Greater London',
            'bill_postcode' => 'SW1A 1AA',
            'bill_country_code' => 'GB',
            'ship_name' => 'John Doe',
            'ship_line1' => '123 Main Street',
            'ship_line2' => 'Flat 4B',
            'ship_city' => 'London',
            'ship_region' => 'Greater London',
            'ship_postcode' => 'SW1A 1AA',
            'ship_country_code' => 'GB',
        ]);

        // Create sample order line
        OrderLine::create([
            'order_id' => $order->id,
            'item_id' => $cashmereItem->id,
            'colourway_id' => $cashmereItem->colourways->first()->id,
            'quantity' => 1,
            'estimated_weight_g' => 500,
            'final_weight_g' => 500,
            'price_estimated_minor' => 2500,
            'price_final_minor' => 2500,
            'attributes' => ['notes' => 'Sample order'],
        ]);
    }
}
