<?php
// Shared header include. Expects $meta = ['title' => '', 'description' => '', 'canonical' => '']
$title = $meta['title'] ?? 'Neil Widdowson — IT & Website Services';
$description = $meta['description'] ?? 'Friendly local IT support and websites that win work in Newcastle and the North East.';
$canonical = $meta['canonical'] ?? 'https://neilwiddowson.co.uk/';
?>
<!doctype html>
<html lang="en-GB" class="dark">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?php echo htmlspecialchars($title, ENT_QUOTES); ?></title>
  <meta name="description" content="<?php echo htmlspecialchars($description, ENT_QUOTES); ?>">
  <link rel="canonical" href="<?php echo htmlspecialchars($canonical, ENT_QUOTES); ?>">
  <meta property="og:title" content="<?php echo htmlspecialchars($title, ENT_QUOTES); ?>">
  <meta property="og:description" content="<?php echo htmlspecialchars($description, ENT_QUOTES); ?>">
  <meta property="og:type" content="website">
  <meta property="og:url" content="<?php echo htmlspecialchars($canonical, ENT_QUOTES); ?>">
  <meta property="og:image" content="https://neilwiddowson.co.uk/img/og-default.png">
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="<?php echo htmlspecialchars($title, ENT_QUOTES); ?>">
  <meta name="twitter:description" content="<?php echo htmlspecialchars($description, ENT_QUOTES); ?>">
  <link rel="icon" href="/favicon.ico">
  <link rel="manifest" href="/manifest.webmanifest">
  <meta name="theme-color" content="#1678e6">
  <link rel="preconnect" href="https://www.googletagmanager.com" crossorigin>
  <link rel="stylesheet" href="/assets/css/app.css">
</head>
<body class="bg-gray-50 text-gray-900">
  <?php include __DIR__.'/navigation.php'; ?>

