<?php
// Shared header include. Expects $meta = ['title' => '', 'description' => '', 'canonical' => '']
$title = $meta['title'] ?? 'Neil Widdowson — IT & Website Services';
$description = $meta['description'] ?? 'Friendly local IT support and websites that win work in Newcastle and the North East.';
$canonical = $meta['canonical'] ?? 'https://neilwiddowson.co.uk/';
?>
<!doctype html>
<html lang="en-GB">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?php echo htmlspecialchars($title, ENT_QUOTES); ?></title>
  <meta name="description" content="<?php echo htmlspecialchars($description, ENT_QUOTES); ?>">
  <link rel="canonical" href="<?php echo htmlspecialchars($canonical, ENT_QUOTES); ?>">
  <meta property="og:title" content="<?php echo htmlspecialchars($title, ENT_QUOTES); ?>">
  <meta property="og:description" content="<?php echo htmlspecialchars($description, ENT_QUOTES); ?>">
  <meta property="og:type" content="website">
  <meta property="og:url" content="<?php echo htmlspecialchars($canonical, ENT_QUOTES); ?>">
  <meta property="og:image" content="https://neilwiddowson.co.uk/img/og-default.png">
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="<?php echo htmlspecialchars($title, ENT_QUOTES); ?>">
  <meta name="twitter:description" content="<?php echo htmlspecialchars($description, ENT_QUOTES); ?>">
  <link rel="icon" href="/favicon.ico">
  <link rel="manifest" href="/manifest.webmanifest">
  <meta name="theme-color" content="#1678e6">
  <link rel="preconnect" href="https://www.googletagmanager.com" crossorigin>
  <link rel="stylesheet" href="/assets/css/app.css">
</head>
<body class="bg-gray-50 text-gray-900">
  <header class="sticky top-0 z-40 bg-white/90 backdrop-blur supports-[backdrop-filter]:bg-white/60 border-b border-gray-100">
    <div class="container flex items-center justify-between h-16">
      <a href="/" class="flex items-center gap-3" aria-label="Neil Widdowson IT & Web home">
        <div class="h-9 w-9 rounded-2xl bg-accent-600 text-white grid place-items-center font-bold">NW</div>
        <div class="text-gray-900 font-semibold leading-tight">
          <span class="block">Neil Widdowson</span>
          <span class="block text-xs text-gray-500">IT & Website Services</span>
        </div>
      </a>
      <nav class="hidden md:flex items-center gap-6" aria-label="Primary">
        <div class="relative group">
          <button class="text-sm text-gray-700 hover:text-gray-900 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500 rounded flex items-center gap-1" aria-expanded="false" aria-haspopup="true">
            Services
            <svg class="h-4 w-4 transition-transform group-hover:rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
            </svg>
          </button>
          <div class="absolute top-full left-0 mt-2 w-64 bg-white rounded-lg shadow-lg border border-gray-100 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50">
            <div class="py-2">
              <a href="/services/website-design.html" class="block px-4 py-3 text-sm text-gray-700 hover:bg-gray-50 hover:text-gray-900">
                <div class="font-medium">Website Design</div>
                <div class="text-xs text-gray-500 mt-1">Fast, mobile-first Joomla sites</div>
              </a>
              <a href="/services/it-support.html" class="block px-4 py-3 text-sm text-gray-700 hover:bg-gray-50 hover:text-gray-900">
                <div class="font-medium">IT Support</div>
                <div class="text-xs text-gray-500 mt-1">Friendly local help & security</div>
              </a>
              <a href="/services/website-care.html" class="block px-4 py-3 text-sm text-gray-700 hover:bg-gray-50 hover:text-gray-900">
                <div class="font-medium">Website Care</div>
                <div class="text-xs text-gray-500 mt-1">Updates, backups & hosting</div>
              </a>
              <a href="/services/software-dev.html" class="block px-4 py-3 text-sm text-gray-700 hover:bg-gray-50 hover:text-gray-900">
                <div class="font-medium">Software Development</div>
                <div class="text-xs text-gray-500 mt-1">Custom apps & AI integrations</div>
              </a>
              <div class="border-t border-gray-100 mt-2 pt-2">
                <a href="/services/" class="block px-4 py-2 text-sm text-accent-600 hover:bg-gray-50 font-medium">View all services</a>
              </div>
            </div>
          </div>
        </div>
        <a class="text-sm text-gray-700 hover:text-gray-900 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500 rounded" href="/portfolio/">Portfolio</a>
        <a class="text-sm text-gray-700 hover:text-gray-900 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500 rounded" href="/pricing/">Pricing</a>
        <a class="text-sm text-gray-700 hover:text-gray-900 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500 rounded" href="/faqs/">FAQs</a>
        <a class="text-sm text-gray-700 hover:text-gray-900 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500 rounded" href="/about/">About</a>
      </nav>
      <div class="hidden md:block">
        <a class="btn-primary" href="/contact/">Get a free quote</a>
      </div>
      <button id="nav-toggle" class="md:hidden inline-flex items-center justify-center h-10 w-10 rounded-xl focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500" aria-controls="mobile-nav" aria-expanded="false" aria-label="Open menu">
        <svg class="h-6 w-6 text-gray-900" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true"><line x1="3" y1="6" x2="21" y2="6"></line><line x1="3" y1="12" x2="21" y2="12"></line><line x1="3" y1="18" x2="21" y2="18"></line></svg>
      </button>
    </div>
    <div id="mobile-nav" class="md:hidden hidden border-t border-gray-100" aria-label="Mobile" role="dialog">
      <div class="container py-3">
        <div class="flex flex-col gap-2">
          <a class="px-2 py-2 rounded-xl hover:bg-gray-50 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500" href="/services/">Services</a>
          <a class="px-2 py-2 rounded-xl hover:bg-gray-50 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500" href="/portfolio/">Portfolio</a>
          <a class="px-2 py-2 rounded-xl hover:bg-gray-50 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500" href="/pricing/">Pricing</a>
          <a class="px-2 py-2 rounded-xl hover:bg-gray-50 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500" href="/faqs/">FAQs</a>
          <a class="px-2 py-2 rounded-xl hover:bg-gray-50 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500" href="/about/">About</a>
          <a class="btn-primary mt-2" href="/contact/">Get a free quote</a>
        </div>
      </div>
    </div>
  </header>

