<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class StatementTransaction extends Model
{
    use HasFactory;

    protected $fillable = [
        'statement_id',
        'cardholder_name',
        'account_number_last4',
        'transaction_date',
        'merchant_name',
        'amount',
        'currency',
        'original_amount',
        'original_currency',
        'conversion_rate',
        'posted_date',
        'transaction_time',
        'authorisation_code',
        'transaction_id_ref',
        'merchant_category',
        'transaction_type',
        'mcc_description',
        'merchant_city',
        'merchant_state',
        'merchant_postcode',
        'mcc',
        'receipt_flag',
        'details',
        'department_hint',
        'account_hint',
        'matched_receipt_id',
    ];

    protected $casts = [
        'transaction_date' => 'date',
        'posted_date' => 'date',
        'amount' => 'decimal:2',
        'original_amount' => 'decimal:2',
        'conversion_rate' => 'decimal:6',
        'receipt_flag' => 'boolean',
    ];

    public function statement(): BelongsTo
    {
        return $this->belongsTo(Statement::class);
    }
}


