<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('custom_sessions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('custom_request_id')->nullable()->constrained()->onDelete('set null');
            $table->string('title');
            $table->text('description')->nullable();
            $table->text('transcript')->nullable();
            $table->string('duration')->nullable(); // in seconds
            $table->string('file_path')->nullable(); // storage path
            $table->string('file_size')->nullable(); // in bytes
            $table->string('voice_type')->default('neutral'); // male, female, neutral
            $table->string('status')->default('queued'); // queued, generating, ready, failed
            $table->json('generation_metadata')->nullable(); // AI generation details
            $table->integer('play_count')->default(0);
            $table->timestamp('generated_at')->nullable();
            $table->timestamp('failed_at')->nullable();
            $table->text('failure_reason')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('custom_sessions');
    }
};
