<div class="space-y-4">
    <div class="flex justify-between items-center">
        <h3 class="text-lg font-semibold">My Receipts</h3>
        <a class="text-blue-600 underline" href="{{ route('user.receipts.upload') }}">Upload</a>
    </div>
    <div class="overflow-x-auto bg-white dark:bg-gray-800 rounded shadow">
        <table class="min-w-full text-sm">
            <thead>
                <tr class="text-left">
                    <th class="px-3 py-2">Date</th>
                    <th class="px-3 py-2">Merchant</th>
                    <th class="px-3 py-2">Amount</th>
                    <th class="px-3 py-2">Dept</th>
                    <th class="px-3 py-2">Account</th>
                    <th class="px-3 py-2">Personal</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($receipts as $r)
                    <tr class="border-t">
                        <td class="px-3 py-2">{{ $r->receipt_date }}</td>
                        <td class="px-3 py-2">{{ $r->merchant_name }}</td>
                        <td class="px-3 py-2">{{ number_format($r->total_amount,2) }} {{ $r->currency }}</td>
                        <td class="px-3 py-2">{{ optional($r->department)->name }}</td>
                        <td class="px-3 py-2">{{ optional($r->account)->name }}</td>
                        <td class="px-3 py-2">{{ $r->is_personal ? 'Yes' : 'No' }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
