<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Support\Facades\Validator;

class NewsletterSignup extends Component
{
    public $email = '';
    public $subscribed = false;
    public $error = '';

    public function subscribe()
    {
        $this->error = '';
        
        $validator = Validator::make(
            ['email' => $this->email],
            ['email' => 'required|email']
        );

        if ($validator->fails()) {
            $this->error = 'Please enter a valid email address.';
            return;
        }

        // Here you would typically save to a newsletter service or database
        // For now, we'll just show success
        
        $this->subscribed = true;
        $this->email = '';
        
        session()->flash('message', 'Thank you for subscribing!');
    }

    public function render()
    {
        return view('livewire.newsletter-signup');
    }
}





