<div class="min-h-screen bg-gradient-to-br from-primary-50 via-accent-50 to-primary-100">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Header -->
        <div class="text-center mb-12">
            <h1 class="text-4xl font-bold font-heading text-neutral-900 mb-4 tracking-heading">
                Request Custom Session
            </h1>
            <p class="text-xl text-neutral-600 max-w-2xl mx-auto leading-relaxed">
                Tell us what you need and we'll create a personalized wellness session just for you.
            </p>
        </div>

        <!-- Success/Error Messages -->
        @if (session()->has('success'))
            <div class="mb-8 p-4 bg-green-50 border border-green-200 rounded-2xl">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm text-green-800">{{ session('success') }}</p>
                    </div>
                </div>
            </div>
        @endif

        @if (session()->has('error'))
            <div class="mb-8 p-4 bg-red-50 border border-red-200 rounded-2xl">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm text-red-800">{{ session('error') }}</p>
                    </div>
                </div>
            </div>
        @endif

        <!-- Form -->
        <div class="bg-white rounded-2xl shadow-md p-8">
            <form wire:submit="submit" class="space-y-6">
                <!-- Topic -->
                <div>
                    <label for="topic" class="block text-sm font-medium text-neutral-700 mb-2">
                        Session Topic <span class="text-red-500">*</span>
                    </label>
                    <input 
                        wire:model="topic"
                        type="text" 
                        id="topic"
                        placeholder="e.g., Stress relief, Better sleep, Confidence building"
                        class="w-full rounded-full border-neutral-200 focus:border-primary-400 focus:ring-primary-200 px-4 py-3 transition-colors @error('topic') border-red-300 focus:border-red-400 focus:ring-red-200 @enderror"
                    >
                    @error('topic')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Description -->
                <div>
                    <label for="description" class="block text-sm font-medium text-neutral-700 mb-2">
                        Detailed Description <span class="text-red-500">*</span>
                    </label>
                    <textarea 
                        wire:model="description"
                        id="description"
                        rows="4"
                        placeholder="Describe what you'd like to achieve, any specific techniques you prefer, or what you're currently struggling with..."
                        class="w-full rounded-2xl border-neutral-200 focus:border-primary-400 focus:ring-primary-200 px-4 py-3 transition-colors resize-none @error('description') border-red-300 focus:border-red-400 focus:ring-red-200 @enderror"
                    ></textarea>
                    @error('description')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Session Length and Voice Preference -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="sessionLength" class="block text-sm font-medium text-neutral-700 mb-2">
                            Session Length <span class="text-red-500">*</span>
                        </label>
                        <select 
                            wire:model="sessionLength"
                            id="sessionLength"
                            class="w-full rounded-full border-neutral-200 focus:border-primary-400 focus:ring-primary-200 px-4 py-3 transition-colors"
                        >
                            <option value="15min">15 minutes</option>
                            <option value="30min">30 minutes</option>
                            <option value="45min">45 minutes</option>
                            <option value="60min">60 minutes</option>
                        </select>
                    </div>

                    <div>
                        <label for="voicePreference" class="block text-sm font-medium text-neutral-700 mb-2">
                            Voice Preference <span class="text-red-500">*</span>
                        </label>
                        <select 
                            wire:model="voicePreference"
                            id="voicePreference"
                            class="w-full rounded-full border-neutral-200 focus:border-primary-400 focus:ring-primary-200 px-4 py-3 transition-colors"
                        >
                            <option value="male">Male voice</option>
                            <option value="female">Female voice</option>
                            <option value="neutral">No preference</option>
                        </select>
                    </div>
                </div>

                <!-- Special Notes -->
                <div>
                    <label for="specialNotes" class="block text-sm font-medium text-neutral-700 mb-2">
                        Special Notes (Optional)
                    </label>
                    <textarea 
                        wire:model="specialNotes"
                        id="specialNotes"
                        rows="3"
                        placeholder="Any additional requirements, triggers to avoid, or specific preferences..."
                        class="w-full rounded-2xl border-neutral-200 focus:border-primary-400 focus:ring-primary-200 px-4 py-3 transition-colors resize-none @error('specialNotes') border-red-300 focus:border-red-400 focus:ring-red-200 @enderror"
                    ></textarea>
                    @error('specialNotes')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Submit Button -->
                <div class="pt-6">
                    @guest
                        <div class="text-center p-6 bg-neutral-50 rounded-2xl mb-6">
                            <p class="text-neutral-600 mb-4">You need to be logged in to request a custom session.</p>
                            <a 
                                href="{{ route('login') }}"
                                class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-full text-white bg-gradient-to-r from-primary-400 to-primary-500 hover:from-primary-500 hover:to-primary-600 transition-all duration-300 transform hover:scale-105 shadow-md hover:shadow-lg"
                            >
                                Sign In to Continue
                            </a>
                        </div>
                    @else
                        <button 
                            type="submit"
                            disabled="{{ $isSubmitting }}"
                            class="w-full inline-flex items-center justify-center px-8 py-4 border border-transparent text-lg font-medium rounded-full text-white bg-gradient-to-r from-primary-400 to-primary-500 hover:from-primary-500 hover:to-primary-600 disabled:from-neutral-300 disabled:to-neutral-400 disabled:cursor-not-allowed transition-all duration-300 transform hover:scale-105 shadow-md hover:shadow-lg"
                        >
                            @if($isSubmitting)
                                <svg class="animate-spin -ml-1 mr-3 h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                </svg>
                                Submitting...
                            @else
                                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                                </svg>
                                Submit Request
                            @endif
                        </button>
                    @endguest
                </div>
            </form>
        </div>

        <!-- Info Section -->
        <div class="mt-12 bg-white rounded-2xl shadow-md p-8">
            <h2 class="text-2xl font-bold font-heading text-neutral-900 mb-6 tracking-heading">
                What Happens Next?
            </h2>
            <div class="grid md:grid-cols-3 gap-6">
                <div class="text-center">
                    <div class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-primary-100 mb-4">
                        <span class="text-2xl font-bold text-primary-600">1</span>
                    </div>
                    <h3 class="text-lg font-semibold font-heading text-neutral-900 mb-2">Submit Request</h3>
                    <p class="text-neutral-600 text-sm leading-relaxed">Fill out the form above with your specific needs and preferences.</p>
                </div>
                <div class="text-center">
                    <div class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-accent-100 mb-4">
                        <span class="text-2xl font-bold text-accent-600">2</span>
                    </div>
                    <h3 class="text-lg font-semibold font-heading text-neutral-900 mb-2">We Review</h3>
                    <p class="text-neutral-600 text-sm leading-relaxed">Our team reviews your request and may ask for clarification if needed.</p>
                </div>
                <div class="text-center">
                    <div class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-primary-100 mb-4">
                        <span class="text-2xl font-bold text-primary-600">3</span>
                    </div>
                    <h3 class="text-lg font-semibold font-heading text-neutral-900 mb-2">Create Session</h3>
                    <p class="text-neutral-600 text-sm leading-relaxed">We create your personalized session and notify you when it's ready.</p>
                </div>
            </div>
        </div>
    </div>
</div>
