<x-app-layout>
    <section class="py-4">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Admin Dashboard</h1>
                <a href="{{ route('admin.seasons.create') }}" class="btn btn-primary rounded-pill">
                    <i class="bi bi-plus-lg me-1"></i> New Season
                </a>
            </div>

            <div class="row g-3">
                <div class="col-md-4">
                    <div class="card shadow-sm h-100">
                        <div class="card-body position-relative">
                            <h6 class="text-muted">Seasons</h6>
                            <p class="display-6 mb-2">{{ \App\Models\Season::count() }}</p>
                            <a href="{{ route('admin.seasons.index') }}" class="btn btn-outline-primary btn-sm rounded-pill">Manage Seasons</a>
                            <a href="{{ route('admin.seasons.index') }}" class="stretched-link" aria-label="Manage Seasons"></a>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card shadow-sm h-100">
                        <div class="card-body position-relative">
                            <h6 class="text-muted">Categories</h6>
                            <p class="display-6 mb-2">{{ \App\Models\Category::count() }}</p>
                            <a href="{{ route('admin.categories.index') }}" class="btn btn-outline-primary btn-sm rounded-pill">Manage Categories</a>
                            <a href="{{ route('admin.categories.index') }}" class="stretched-link" aria-label="Manage Categories"></a>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card shadow-sm h-100">
                        <div class="card-body position-relative">
                            <h6 class="text-muted">Items</h6>
                            <p class="display-6 mb-2">{{ \App\Models\Item::count() }}</p>
                            <a href="{{ route('admin.items.index') }}" class="btn btn-outline-primary btn-sm rounded-pill">Manage Items</a>
                            <a href="{{ route('admin.items.index') }}" class="stretched-link" aria-label="Manage Items"></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</x-app-layout>


