<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Statement extends Model
{
    protected $fillable = [
        'cardholder_name',
        'account_number_masked',
        'period_start',
        'period_end',
        'currency',
        'status',
        'uploaded_by_user_id',
        'source_filename',
        'storage_path',
        'file_hash',
        'meta',
    ];

    protected $casts = [
        'period_start' => 'date',
        'period_end' => 'date',
        'meta' => 'array',
    ];

    public function transactions(): HasMany
    {
        return $this->hasMany(StatementTransaction::class);
    }

    public function uploader(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uploaded_by_user_id');
    }
}
