<?php

namespace App\Jobs;

use App\Models\StatementTransaction;
use App\Services\Matching\TransactionClassificationService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ClassifyTransaction implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $tries = 3;
    public int $timeout = 120;

    public function __construct(public int $transactionId) {}

    public function handle(TransactionClassificationService $service): void
    {
        $txn = StatementTransaction::find($this->transactionId);
        if (!$txn) return;
        $service->classify($txn);
    }
}


