<?php

namespace App\Http\Livewire\Dashboard;

use Livewire\Component;
use Livewire\Attributes\Computed;
use Illuminate\Support\Facades\DB;
use App\Http\Livewire\BaseComponent;

class SaleValueByMonth extends BaseComponent
{
    #[Computed(persist: true, key: 'sale-value-by-month_raw_data')]
    public function rawR(){
        return DB::select("
            SELECT
                customers.name as customer,
                SUM(CASE
                    WHEN sls.shipped_qty > 0 THEN sls.shipped_qty * CONVERT_CURRENCY(COALESCE(pr.quote, 0), customers.currency, '£', co.seasons_id)
                    ELSE sls.qty * CONVERT_CURRENCY(COALESCE(pr.quote, 0), customers.currency, '£', co.seasons_id)
                END) AS total_sale

            FROM customer_order_line_quantities colq
            JOIN customer_order_lines col ON col.id=colq.customer_order_lines_id and col.cancelled = 0
            JOIN customer_orders co ON co.id=col.customer_orders_id and co.cancelled = 0
            JOIN shipment_lines sl ON sl.customer_order_lines_id = col.id
            JOIN shipment_line_sizes sls ON sls.shipment_line_id = sl.id and sls.sizes_id = colq.sizes_id
            JOIN customers on customers.id = co.customers_id
            JOIN colourways cw ON cw.id = col.colourways_id
            LEFT JOIN price_resolutions pr ON pr.style_versions_id = cw.style_versions_id 
                AND pr.colourways_id = cw.id 
                AND pr.sizes_id = sls.sizes_id 
                AND pr.phase_id IS NULL 
                AND pr.season_id = co.seasons_id
                AND pr.fresh_at IS NOT NULL

            WHERE colq.deleted_at is null
            AND exfty BETWEEN DATE_SUB(NOW(), INTERVAL 12 MONTH) AND NOW()
            group by customer
            order by total_sale desc
            limit 6
        ");
    }
    public function render()
    {
        $labels = [];
        $salesValues = [];
        $costValues = [];
        foreach($this->rawR as $row) {
            $labels[] = $row->customer;
            $salesValues[] = $row->total_sale;
        }

        $data = [
            'labels' => $labels,
            'datasets' => [
                [
                    'label' => 'Top 10 Customers',
                    'data' => $salesValues,
                    'backgroundColor' => [
                        '#142e5085',
                        '#c9c9c985',
                        '#f7c54885',
                        '#f0545485',
                        '#9966ff85',
                        '#ff9f4085'
                    ],
                    'pointStyle' => 'circle',
                    'pointRadius' => 5,
                    'pointHoverRadius' => 10
                ],
            ]
        ];

        // dd($data);

        return view('livewire.dashboard.sale-value-by-month', ['data' => $data]);
    }
}
