<?php

namespace App\Http\Livewire\Production\Reports;

use App\Models\Styles;
use App\Models\Seasons;
use Livewire\Component;
use App\Models\Customer;
use App\Models\Shipment;
use App\Models\Suppliers;
use App\Models\Departments;
use Illuminate\Support\Str;
use Livewire\Attributes\On;
use App\Models\ShipmentLine;
use Livewire\WithPagination;
use App\Livewire\Forms\CPForm;
use Livewire\Attributes\Computed;
use App\Livewire\Forms\AsosCPForm;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class CriticalPathTesting extends Component
{
    use WithPagination;
    public CPForm $form;

    public $paginate = 21, $view = "unshipped", $department = NULL, $customer = 1, $season = 1, $factory = "", $coo, $category = NULL, $search = "";
    public $selected = [];
    private $sl;
    public $sizes;

    public $columns = [
        'version' => 1.14,
        'Factory' => TRUE,
        'Image' => TRUE,
        'RT Number' => TRUE,
        'RT Description' => TRUE,
        'PO Number' => TRUE,
        'Customer Reference' => TRUE,
        'Colour' => TRUE,
        'Sell Price' => TRUE,
        'Total Qty' => TRUE,
        'Warehouse' => TRUE,
        'Order Date' => TRUE,
        'Sent to Factory' => TRUE,
        'Shipment Complete' => TRUE,

        'Yarn' => TRUE,
        'Yarn Colour' => TRUE,
        'Factory Order Yarn (FOY)' => TRUE,
        'PRODs' => TRUE,
        'Yarn Comments' => TRUE,

        'Buttons' => TRUE,
        'Labels' => TRUE,
        'Care' => TRUE,
        'Photoshoot Deadline' => TRUE,
        'Sealer Deadline' => TRUE,
        'Sealer Sample' => TRUE,
        'Start Knit' => TRUE,
        'Shipment Sample' => TRUE,
        'Exfty' => TRUE,
        'Revised Exfty' => TRUE,
        'Customer Exfty' => TRUE,
        'Comments' => TRUE,
    ];

    public function updatedForm($val, $var){
        $this->form->save($val, $var);
    }

    public function go(){

    }

    public function clearFilters(){
        $this->reset('paginate', 'view', 'department', 'customer', 'season', 'factory', 'coo', 'category', 'search');
        $this->updatedPaginate();
        $this->updatedSeason();
        $this->updatedDepartment();
        $this->updatedCustomer();
        $this->updatedFactory();
        $this->updatedCoo();
        $this->updatedCategory();
        $this->updatedSearch();
    }

    #[On('close-modal')]
	public function modalClosed(){
		$this->render();
	}

    public function mount(){
        if(!empty(auth()->user()->setting('columns_asos_cp')) && auth()->user()->setting('columns_asos_cp')['version'] == $this->columns['version'])
			$this->columns = auth()->user()->setting('columns_asos_cp');
        $this->paginate = auth()->user()->setting('asos_cp_paginate');
		$this->season = auth()->user()->setting('wholesale_critical_path_season');
		$this->department = auth()->user()->setting('wholesale_critical_path_department');
		$this->customer = auth()->user()->setting('wholesale_critical_path_customer');
		$this->factory = auth()->user()->setting('wholesale_critical_path_factory');
		$this->coo = auth()->user()->setting('wholesale_critical_path_coo');
		$this->category = auth()->user()->setting('wholesale_critical_path_category');
		$this->search = auth()->user()->setting('wholesale_critical_path_search');

        $this->sl = $this->getData();
        $this->form->mount($this->sl->toArray());
        $this->sizes = $this->sl->pluck('sizes')->collapse()->unique('size')->pluck('size', 'sizes_id');
    }
    public function updatedPaginate(){ auth()->user()->settings(['asos_cp_paginate' => $this->paginate]); }
	public function updatedColumns(){ auth()->user()->settings(['columns_asos_cp' => $this->columns]); }
    public function updatedSeason(){ auth()->user()->settings(['wholesale_critical_path_season' => $this->season]); }
	public function updatedDepartment(){ auth()->user()->settings(['wholesale_critical_path_department' => $this->department]); }
	public function updatedCustomer(){ auth()->user()->settings(['wholesale_critical_path_customer' => $this->customer]); }
	public function updatedFactory(){ auth()->user()->settings(['wholesale_critical_path_factory' => $this->factory]); }
	public function updatedCoo(){ auth()->user()->settings(['wholesale_critical_path_coo' => $this->coo]); }
	public function updatedCategory(){ auth()->user()->settings(['wholesale_critical_path_category' => $this->category]); }
	public function updatedSearch(){ auth()->user()->settings(['wholesale_critical_path_search' => $this->search]); }

    public function render()
    {
        if (empty($this->sl)) {
            $this->mount();
        }

        return view('livewire.production.reports.critical-path-testing', ['sl' => $this->sl])->layout('layouts.fluid');
    }

    public function getStyleCount(Styles $style){
        return $style->style_versions->flatMap(function ($version) {
            return $version->colourways->flatMap(function ($colourway) {
                return $colourway->customer_order_lines;
            });
        })->count();
    }


    public function edit(){
		$this->dispatch('edit-cp', selected: json_encode(array_keys($this->selected, TRUE)));
	}

    public function getData(){
        $query = ShipmentLine::
        select(
            'shipment_lines.*',
            'factories.name as factory',
            'colourways.img_thumb',
            'colourways.id as colourways_id',
            'styles.designs_id as designs_id',
            'customer_orders.customer_po',
            'customer_orders.id as customer_orders_id',
            'styles.customer_ref',
            'styles.id as styles_id',
            'designs.description',
            'designs.id as designs_id',
            'colourways.name as colourways_name',
            'customers.currency as customer_currency',
            'factories.currency as factory_currency',
            'shipment_lines.first_exfty',
            'shipment_lines.exfty',
            'customer_addresses.name as customer_address',

            'colourways.customer_description',
            'customer_orders.order_date as order_date',
            'customer_order_lines.id as customer_order_lines_id',
            'customer_order_lines.order_sent_factory',
            'colourways.composition',
            'colourways.colour_approval_comments',

            'customer_order_lines.bulk_yarn_order_date',
            'customer_order_lines.bulk_yarn_order_comments',
            'customer_order_lines.bulk_yarn_order_delivery_date',
            'customer_order_lines.bulk_yarn_order_delivery_comments',

            'customer_order_lines.start_knit',
            'shipment_lines.start_knit_comments',
            'styles.customer_samp_no',

            'styles.green_seal_approval_comments',
            'styles.photo_shoot_sample_comments',

            'colourways.accessories',
            'colourways.testing_comments',



            'shipment_lines.complete',
            'shipment_lines.id as shipment_lines_id',
            'shipment_lines.yarn_comments',

            'shipment_lines.buttons',
            'shipment_lines.buttons_done',
            'shipment_lines.labels',
            'shipment_lines.labels_done',
            'shipment_lines.care',
            'shipment_lines.care_done',
            'shipment_lines.factory_order_yarn',

            'customer_order_lines.factory_cust_date',

            'shipment_lines.cp_notes',


            'prices.id as prices_id',
            'prices.discount',
            )
            // ->selectRaw("CASE WHEN(shipment_lines.factory_order_yarn = 1) THEN 'true' ELSE 'false' END as factory_order_yarn")
            ->selectRaw("FORMAT(prices.cmt,2) as cmt")
            ->selectRaw("FORMAT(prices.quote,2) as quote")

            ->selectRaw("(SELECT CONCAT('[', GROUP_CONCAT(JSON_OBJECT('id', yc.id, 'yarn', y.description, 'count', counts.count, 'colour', yc.description, 'colour_id', yc.id, 'yarn_id', y.id, 'prods', (SELECT CONCAT('[', GROUP_CONCAT(JSON_OBJECT('prod', yo.id, 'actual_ship_date', yol.actual_ship_date, 'delivered', yol.delivery_date, 'ship_date', yol.ship_date)), ']') FROM yarn_orders yo JOIN yarn_order_lines yol ON yol.yarn_order_id = yo.id AND yol.yarn_colours_id = cy.yarn_colours_id JOIN yarn_order_line_styles yols ON yols.yarn_order_lines_id = yol.id AND yols.customer_order_lines_id = customer_order_lines.id))), ']') FROM colourway_yarns cy JOIN yarn_colours yc ON yc.id = cy.yarn_colours_id JOIN yarns y ON y.id = yc.yarn_id JOIN counts ON counts.id = y.counts_id WHERE cy.colourways_id = colourways.id) as yarns")
            ->selectRaw("
                COALESCE(
                    CASE WHEN shipment_lines.sealer_status IS NOT NULL THEN
                        json_object(
                            'status', shipment_lines.sealer_status,
                            'id', NULL,
                            'comments', shipment_lines.sealer_comments,
                            'date_sent', NULL,
                            'note', '(SS)'
                        )
                    END,
                    (
                        select
                            json_object(
                                'status', s.status,
                                'id', s.id,
                                'comments', s.comments,
                                'date_sent', s.date_sent,
                                'note', NULL
                            ) as sample
                        from
                            samples s
                        where
                            s.colourways_id = colourways.id
                            and s.sample_types_id = 7
                        order by s.created_at DESC
                        limit 0, 1
                    ),
                    CASE WHEN json_extract(json_extract(customers.settings, '$.\"carryover-samples-required\"'), '$.\"7\"') = true
                        THEN json_object( 'status', 'Required', 'id', NULL, 'comments', NULL, 'date_sent', NULL, 'note', NULL)
                    END,
                    CASE WHEN styles.carryover = 1
                        THEN json_object( 'status', 'Not Required', 'id', NULL, 'comments', NULL, 'date_sent', NULL, 'note', '(Carryover)')
                    END,
                    CASE WHEN json_extract(customers.samples_required, '$.\"7\"') = true
                        THEN json_object( 'status', 'Required', 'id', NULL, 'comments', NULL, 'date_sent', NULL, 'note', NULL)
                        ELSE json_object( 'status', 'Not Required', 'id', NULL, 'comments', NULL, 'date_sent', NULL, 'note', NULL)
                    END
                ) AS shipment
            ")
            ->selectRaw("
                COALESCE(
                    CASE WHEN shipment_lines.sealer_status IS NOT NULL THEN
                        json_object(
                            'status', shipment_lines.sealer_status,
                            'id', NULL,
                            'comments', shipment_lines.sealer_comments,
                            'date_sent', NULL,
                            'note', '(SS)'
                        )
                    END,

                    (
                        SELECT
                            json_object(
                                'status', s.status,
                                'id', s.id,
                                'comments', s.comments,
                                'date_sent', s.date_sent,
                                'note', CASE WHEN s.colourways_id != colourways.id THEN (c.name) END
                            ) as sample
                        FROM style_versions sv
                        INNER JOIN colourways c ON sv.id = c.style_versions_id
                        INNER JOIN samples s ON s.colourways_id = c.id AND s.sample_types_id=3
                        WHERE sv.id = style_versions.id
                        ORDER BY
                        CASE WHEN s.colourways_id = colourways.id THEN 0
                            ELSE 1
                        END,
                        s.created_at DESC
                        LIMIT 1
                    ),
                    CASE WHEN json_extract(json_extract(customers.settings, '$.\"carryover-samples-required\"'), '$.\"3\"') = true
                        THEN json_object( 'status', 'Required', 'id', NULL, 'comments', NULL, 'date_sent', NULL, 'note', NULL)
                    END,
                    CASE WHEN styles.carryover = 1
                        THEN json_object( 'status', 'Not Required', 'id', NULL, 'comments', NULL, 'date_sent', NULL, 'note', '(Carryover)')
                    END,
                    CASE WHEN json_extract(customers.samples_required, '$.\"3\"') = true
                        THEN json_object( 'status', 'Required', 'id', NULL, 'comments', NULL, 'date_sent', NULL, 'note', NULL)
                        ELSE json_object( 'status', 'Not Required', 'id', NULL, 'comments', NULL, 'date_sent', NULL, 'note', NULL)
                    END
                ) AS sealer
            ")

            ->selectRaw("
            (
                select
                concat(
                    '[',
                    group_concat(
                    JSON_OBJECT(
                        'colq_id', colq.id,
                        'sls_id', sls.id,
                        'size', sizes.name,
                        'sizes_id', sizes.id,
                        'qty', sls.qty,
                        'shipped_qty', sls.shipped_qty,
                        'quote', COALESCE(pr.quote, 0)
                    ) SEPARATOR ','
                    ),
                    ']'
                )
                from  shipment_line_sizes sls
                join sizes on sizes.id = sls.sizes_id and sls.shipment_line_id = shipment_lines.id
                join customer_order_line_quantities colq on colq.customer_order_lines_id = customer_order_lines.id and colq.sizes_id = sls.sizes_id
                group by sls.shipment_line_id
            ) AS sizes
        ")


        ->selectRaw('COUNT(*) OVER (PARTITION BY colourways.id, shipment_lines.exfty) AS colourway_count')
        ->selectRaw('FIRST_VALUE(shipment_lines.id) OVER (PARTITION BY colourways.id, shipment_lines.exfty) AS colourway_first')
        ->selectRaw('LAST_VALUE(shipment_lines.id) OVER (PARTITION BY colourways.id, shipment_lines.exfty) AS colourway_last')

        // ->whereRelation('customer_order_lines.customer_orders', 'customers_id', '=', '6')

        ->Join('customer_order_lines', function($join)
        {
            $join->on('customer_order_lines.id', '=', 'shipment_lines.customer_order_lines_id');
            $join->on('customer_order_lines.cancelled', '=', DB::raw(0));
        })
        ->Join('customer_orders', function($join)
        {
            $join->on('customer_orders.id', '=', 'customer_order_lines.customer_orders_id');
            $join->on('customer_orders.order_type', '=', DB::raw("'wholesale'"));
            $join->on('customer_orders.cancelled', '=', DB::raw(0));
        })
        ->join('customer_addresses', 'customer_addresses.id', '=', 'customer_orders.customer_addresses_id')
        ->join('customers', 'customers.id', '=', 'customer_orders.customers_id')
        ->join('colourways', 'colourways.id', '=', 'customer_order_lines.colourways_id')
        ->join('style_versions', 'style_versions.id', '=', 'colourways.style_versions_id')
        ->join('suppliers as factories', 'factories.id', '=', 'style_versions.factory_id')
        ->join('styles', 'styles.id', '=', 'style_versions.styles_id')
        ->join('designs', 'designs.id', '=', 'styles.designs_id')
        ->leftJoin(DB::raw('(
            SELECT style_versions_id, MAX(prices.id) as id, MAX(cmt) as cmt, MAX(quote) as quote, MAX(discount) as discount, MAX(updated_at) AS max_updated_at
            FROM prices
            GROUP BY style_versions_id
          ) AS prices'), function ($join) {
            $join->on('prices.style_versions_id', '=', 'style_versions.id');
          });

        if($this->view == "unshipped"){
			$query->where('shipment_lines.complete', FALSE);
		}
		if($this->view == "financeNC"){
			$query->where('shipment_lines.invoiced', FALSE);
		}

        // $query->whereIn('customer_orders.departments_id', Auth::user()->user_departments->pluck('departments_id'));

		$query->where('customer_orders.seasons_id', $this->season);
		$query->where('customer_orders.customers_id', $this->customer);
		if(!empty($this->factory)){
			$query->where('style_versions.factory_id', $this->factory);
		}
		if(!empty($this->coo)){
			$query->where('factories.coo', $this->coo);
		}
		if(!empty($this->department)){
			$query->where('customer_orders.departments_id', $this->department);
		}
		if(!empty($this->category)){
			$query->where('styles.category', $this->category);
		}

        if(!empty($this->search)){
            $query->where(function($query) {
                $query->where('designs.description', 'like', "%{$this->search}%")
                ->orwhere('styles.customer_ref', 'like', "%{$this->search}%")
                ->orwhere('designs.id', 'like', "%{$this->search}%")
                ->orwhere('customer_orders.customer_po', 'like', "%{$this->search}%")
                ->orwhere('colourways.name', 'like', "%{$this->search}%");
            });
		}

        $query->orderBy('shipment_lines.exfty', 'asc')
        ->orderBy('styles.id', 'asc')
        ->orderBy('style_versions.factory_id', 'asc')
        ->orderBy('colourways.id', 'asc');
        $sl = $query->get();

        foreach($sl as $l=>$sline){
            $sline->rowspanStyle =
                $sl ->where('exfty', $sline->exfty)
                    ->where('styles_id', $sline->styles_id)->count();
                $sl[$l]->sizes = array_column(json_decode($sline->sizes, true), null, 'sizes_id');
                $yarns = json_decode($sline->yarns);
                foreach($yarns ?? [] as $y=>$yarn){
                    if(!empty($yarn->prods)){
                        $yarn->prods = collect(json_decode($yarn->prods));
                        $sl[$l]->has_prods = 1;
                    }
                    elseif($sl[$l]->has_prods == 0){
                        $sl[$l]->has_prods = 0;
                    }
                }
                $sl[$l]->yarns = $yarns;

                $sl[$l]->factory_order_yarn = (bool) $sline->factory_order_yarn;
                $sl[$l]->buttons_done = (bool) $sline->buttons_done;
                $sl[$l]->labels_done = (bool) $sline->labels_done;
                $sl[$l]->care_done = (bool) $sline->care_done;
                $sl[$l]->complete = (bool) $sline->complete;

                $sl[$l]->foy_ordered = (bool) $sline->foy_ordered;
                $sl[$l]->foy_delivered = (bool) $sline->foy_delivered;

                $sl[$l]->buttons_ordered = (bool) $sline->buttons_ordered;

                $sl[$l]->description = Str::title($sline->description);
                $sl[$l]->colourways_name = Str::title($sline->colourways_name);
                $sl[$l]->complete = (boolean)$sline->complete;

                $sl[$l]->sealer = json_decode($sline->sealer);
                $sl[$l]->shipment = json_decode($sline->shipment);
        }
        return $sl;
    }

    #[Computed]
	public function seasons(){
		return Seasons::allCached();
	}
	#[Computed]
	public function suppliers(){
		return Suppliers::get()->sortBy('name');
	}
	#[Computed]
	public function factories(){
		return $this->suppliers->where('type', 'factory');
	}
	#[Computed]
	public function customers(){
		return Customer::get()->sortBy('name');
	}
	#[Computed]
	public function departments(){
		return Departments::get()->sortBy('name');
	}
	#[Computed]
	public function trucks(){
		return Shipment::get();
	}
}
