@section('title', 'My Orders - Yarn Store')

<div class="py-4" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <h1 class="fw-bold mb-0">My Orders</h1>
    </div>
</div>

<div class="container py-5">
    <div class="row">
        <div class="col-lg-3 mb-4 mb-lg-0">
            @include('partials.account-sidebar')
        </div>

        <div class="col-lg-9">
            <div class="ys-card p-4">
                @if($orders->count() > 0)
                    @foreach($orders as $order)
                        <div class="border rounded p-4 mb-3">
                            <div class="row">
                                <div class="col-md-8 mb-3 mb-md-0">
                                    <h5 class="fw-bold mb-2">Order #{{ $order->order_number }}</h5>
                                    <p class="text-muted small mb-2">
                                        Placed on {{ $order->created_at->format('d F Y') }}
                                    </p>
                                    <span class="badge bg-primary">{{ ucfirst($order->status) }}</span>
                                </div>
                                <div class="col-md-4 text-md-end">
                                    <p class="mb-2">
                                        <span class="h4 fw-bold" style="color: var(--ys-primary);">
                                            £{{ number_format($order->initial_total_amount, 2) }}
                                        </span>
                                    </p>
                                    <a href="{{ route('account.order', $order->id) }}" class="btn btn-sm btn-ys-primary">
                                        View Details
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach

                    <div class="mt-4">
                        {{ $orders->links() }}
                    </div>
                @else
                    <div class="text-center py-5">
                        <svg xmlns="http://www.w3.org/2000/svg" width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mb-3" style="color: var(--ys-gray);">
                            <circle cx="9" cy="21" r="1"></circle>
                            <circle cx="20" cy="21" r="1"></circle>
                            <path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"></path>
                        </svg>
                        <h4 class="fw-bold mb-2">No orders yet</h4>
                        <p class="text-muted mb-4">Start shopping to place your first order</p>
                        <a href="{{ route('shop.all') }}" class="btn btn-ys-primary">
                            Browse Products
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

