@extends('layouts.shop')

@section('title', 'Login - Yarn Store')

@section('content')
<div class="py-4" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb ys-breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item active">Login</li>
            </ol>
        </nav>
        
        <h1 class="fw-bold mb-0">Login to Your Account</h1>
    </div>
</div>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-5 col-md-7">
            <div class="ys-card p-4 p-md-5">
                <div class="text-center mb-4">
                    <h2 class="fw-bold mb-2">Welcome Back</h2>
                    <p class="text-muted">Sign in to your account to continue shopping</p>
                </div>

                <form method="POST" action="{{ route('login') }}">
                    @csrf

                    <div class="mb-4">
                        <label for="email" class="form-label fw-semibold">{{ __('Email Address') }}</label>
                        <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus placeholder="Enter your email">

                        @error('email')
                            <div class="invalid-feedback d-block" role="alert">
                                <strong>{{ $message }}</strong>
                            </div>
                        @enderror
                    </div>

                    <div class="mb-4">
                        <label for="password" class="form-label fw-semibold">{{ __('Password') }}</label>
                        <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password" placeholder="Enter your password">

                        @error('password')
                            <div class="invalid-feedback d-block" role="alert">
                                <strong>{{ $message }}</strong>
                            </div>
                        @enderror
                    </div>

                    <div class="mb-4">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                            <label class="form-check-label" for="remember">
                                {{ __('Remember Me') }}
                            </label>
                        </div>
                    </div>

                    <div class="d-grid mb-3">
                        <button type="submit" class="btn btn-ys-primary btn-lg">
                            {{ __('Login') }}
                        </button>
                    </div>

                    @if (Route::has('password.request'))
                        <div class="text-center mb-4">
                            <a class="text-decoration-none" href="{{ route('password.request') }}" style="color: var(--ys-moss-green-dark);">
                                {{ __('Forgot Your Password?') }}
                            </a>
                        </div>
                    @endif

                    <div class="border-top pt-4 text-center">
                        <p class="text-muted mb-0">Don't have an account? 
                            <a href="{{ route('register') }}" class="text-decoration-none fw-semibold" style="color: var(--ys-moss-green-dark);">
                                Register here
                            </a>
                        </p>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
