const db = require('./src/db-multi-tenant');

async function checkSchema() {
  try {
    const result = await db.pool.query(`
      SELECT column_name, data_type, is_nullable, column_default
      FROM information_schema.columns
      WHERE table_name = 'subscription_tiers'
      ORDER BY ordinal_position
    `);
    
    console.log('Subscription Tiers Table Schema:');
    console.log('================================\n');
    result.rows.forEach(col => {
      console.log(`${col.column_name}: ${col.data_type} ${col.is_nullable === 'NO' ? 'NOT NULL' : 'NULL'}`);
    });
    
    // Check primary key
    const pkResult = await db.pool.query(`
      SELECT constraint_name, column_name
      FROM information_schema.key_column_usage
      WHERE table_name = 'subscription_tiers'
        AND constraint_name LIKE '%pkey%'
    `);
    
    console.log('\nPrimary Key:');
    pkResult.rows.forEach(row => {
      console.log(`  ${row.column_name}`);
    });
    
    process.exit(0);
  } catch (error) {
    console.error('Error:', error.message);
    process.exit(1);
  }
}

checkSchema();

