@php
    $heroImage = 'https://as2.ftcdn.net/v2/jpg/05/73/25/21/1000_F_573252161_2yB7QmX2ZtS5e1d5Yy0mPi3oJt4GtwqZ.jpg'; // Luxury textile texture
    $gallery = [
        'https://as2.ftcdn.net/v2/jpg/03/65/51/06/1000_F_365510635_E8b3EsXrTq7F4QyYxw0qBz1lWY0eH6gS.jpg', // Merino wool close-up
        'https://as2.ftcdn.net/v2/jpg/05/86/66/70/1000_F_586667041_7K5Z5B5oC8BzT1Vd0zWv0qPlrT3Jw2sS.jpg', // Cashmere texture
        'https://as2.ftcdn.net/v2/jpg/03/23/48/96/1000_F_323489628_C0jQH0QxWgB1p0ibKcJv8XoH8Yk4m0H0.jpg', // Silk blend
        'https://as2.ftcdn.net/v2/jpg/05/73/25/21/1000_F_573252161_2yB7QmX2ZtS5e1d5Yy0mPi3oJt4GtwqZ.jpg', // Premium yarn
    ];
@endphp

<x-app-layout>
    <!-- Hero Section -->
    <section class="hero-section position-relative overflow-hidden bg-dark text-white">
        <div class="hero-background">
            <img src="{{ $heroImage }}" alt="Luxury Textiles" class="hero-image">
            <div class="hero-overlay"></div>
        </div>
        <div class="container position-relative" style="z-index: 2;">
            <div class="row align-items-center" style="min-height: 90vh;">
                <div class="col-lg-7 py-5">
                    <div class="hero-content" data-aos="fade-up" data-aos-delay="200">
                        <span class="badge bg-primary-subtle text-primary fw-semibold mb-4 px-3 py-2">
                            <i class="bi bi-stars me-2"></i>New Season Collection
                        </span>
                        <h1 class="display-3 fw-light mb-4 text-white">
                            The Yarn Store
                            <span class="d-block fw-normal fs-2 mt-2 text-light">Exceptional Fibres</span>
                        </h1>
                        <p class="lead mb-5 text-light opacity-90">
                            Discover the world's finest yarns from legendary Italian mills. Merino, cashmere, and silk blends 
                            crafted with generations of expertise. Every skein tells a story of luxury and tradition.
                        </p>
                        <div class="d-flex gap-3 flex-wrap">
                            <a href="#collection" class="btn btn-primary btn-lg px-4 py-3">
                                <i class="bi bi-bag-heart me-2"></i>Explore Collection
                            </a>
                            <a href="#about" class="btn btn-outline-light btn-lg px-4 py-3">
                                <i class="bi bi-info-circle me-2"></i>Our Story
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="scroll-indicator">
            <div class="scroll-arrow"></div>
        </div>
    </section>

    <!-- Features Section -->
    <section id="features" class="py-5 bg-white">
        <div class="container">
            <div class="text-center mb-5" data-aos="fade-up">
                <h2 class="fw-light display-6 mb-3">Why The Yarn Store?</h2>
                <p class="text-muted lead">Where heritage meets innovation in every fibre</p>
            </div>
            <div class="row g-4">
                <div class="col-md-4" data-aos="fade-up" data-aos-delay="100">
                    <div class="feature-card text-center p-4 h-100">
                        <div class="feature-icon mb-4">
                            <i class="bi bi-award display-4 text-primary"></i>
                        </div>
                        <h5 class="fw-semibold mb-3">Heritage Quality</h5>
                        <p class="text-muted">Sourced from Italy's most prestigious mills, including Zegna Baruffa, with over 150 years of textile excellence.</p>
                    </div>
                </div>
                <div class="col-md-4" data-aos="fade-up" data-aos-delay="200">
                    <div class="feature-card text-center p-4 h-100">
                        <div class="feature-icon mb-4">
                            <i class="bi bi-palette2 display-4 text-primary"></i>
                        </div>
                        <h5 class="fw-semibold mb-3">Curated Palettes</h5>
                        <p class="text-muted">Seasonally curated colour stories that inspire and coordinate perfectly across your entire collection.</p>
                    </div>
                </div>
                <div class="col-md-4" data-aos="fade-up" data-aos-delay="300">
                    <div class="feature-card text-center p-4 h-100">
                        <div class="feature-icon mb-4">
                            <i class="bi bi-heart display-4 text-primary"></i>
                        </div>
                        <h5 class="fw-semibold mb-3">Personal Service</h5>
                        <p class="text-muted">Expert guidance from our team of textile specialists, ensuring you find the perfect yarn for every project.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section id="about" class="py-5 bg-light">
        <div class="container">
            <div class="row align-items-center g-5">
                <div class="col-lg-6" data-aos="fade-right">
                    <div class="about-image position-relative">
                        <div class="ratio ratio-4x3 rounded overflow-hidden shadow-lg">
                            <img src="{{ $gallery[0] }}" class="w-100 h-100 object-fit-cover" alt="Merino Wool">
                        </div>
                        <div class="floating-badge">
                            <span class="badge bg-primary px-3 py-2">Est. 2024</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6" data-aos="fade-left">
                    <h2 class="fw-light display-6 mb-4">A Legacy of Excellence</h2>
                    <p class="text-muted mb-4 lead">
                        The Yarn Store represents the pinnacle of textile craftsmanship. We partner with legendary Italian mills 
                        like Zegna Baruffa, whose expertise spans generations of luxury fibre production.
                    </p>
                    <p class="text-muted mb-4">
                        From the finest merino wool to the most luxurious cashmere blends, every yarn in our collection 
                        is carefully selected for its exceptional quality, beautiful hand, and timeless appeal.
                    </p>
                    <div class="row g-3">
                        <div class="col-6">
                            <div class="d-flex align-items-center gap-2">
                                <i class="bi bi-check-circle-fill text-success"></i>
                                <span class="small">Premium Italian Mills</span>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="d-flex align-items-center gap-2">
                                <i class="bi bi-check-circle-fill text-success"></i>
                                <span class="small">Sustainable Sourcing</span>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="d-flex align-items-center gap-2">
                                <i class="bi bi-check-circle-fill text-success"></i>
                                <span class="small">Expert Consultation</span>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="d-flex align-items-center gap-2">
                                <i class="bi bi-check-circle-fill text-success"></i>
                                <span class="small">Worldwide Shipping</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Collection Preview -->
    <section id="collection" class="py-5 bg-white">
        <div class="container">
            <div class="text-center mb-5" data-aos="fade-up">
                <h2 class="fw-light display-6 mb-3">Signature Collection</h2>
                <p class="text-muted lead">Discover our curated selection of the world's finest yarns</p>
            </div>
            <div class="row g-4">
                <div class="col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="100">
                    <div class="collection-card position-relative overflow-hidden rounded shadow-sm">
                        <div class="ratio ratio-1x1">
                            <img src="{{ $gallery[1] }}" class="w-100 h-100 object-fit-cover" alt="Merino Collection">
                        </div>
                        <div class="collection-overlay">
                            <div class="collection-content text-center text-white">
                                <h5 class="fw-semibold mb-2">Merino Collection</h5>
                                <p class="small opacity-90">Ultra-fine Italian merino wool</p>
                                <span class="badge bg-primary">Coming Soon</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="200">
                    <div class="collection-card position-relative overflow-hidden rounded shadow-sm">
                        <div class="ratio ratio-1x1">
                            <img src="{{ $gallery[2] }}" class="w-100 h-100 object-fit-cover" alt="Cashmere Blend">
                        </div>
                        <div class="collection-overlay">
                            <div class="collection-content text-center text-white">
                                <h5 class="fw-semibold mb-2">Cashmere Blend</h5>
                                <p class="small opacity-90">Luxury cashmere and silk</p>
                                <span class="badge bg-primary">Coming Soon</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="300">
                    <div class="collection-card position-relative overflow-hidden rounded shadow-sm">
                        <div class="ratio ratio-1x1">
                            <img src="{{ $gallery[3] }}" class="w-100 h-100 object-fit-cover" alt="Silk Collection">
                        </div>
                        <div class="collection-overlay">
                            <div class="collection-content text-center text-white">
                                <h5 class="fw-semibold mb-2">Silk Collection</h5>
                                <p class="small opacity-90">Pure mulberry silk</p>
                                <span class="badge bg-primary">Coming Soon</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="400">
                    <div class="collection-card position-relative overflow-hidden rounded shadow-sm">
                        <div class="ratio ratio-1x1">
                            <img src="{{ $gallery[0] }}" class="w-100 h-100 object-fit-cover" alt="Limited Edition">
                        </div>
                        <div class="collection-overlay">
                            <div class="collection-content text-center text-white">
                                <h5 class="fw-semibold mb-2">Limited Edition</h5>
                                <p class="small opacity-90">Exclusive seasonal releases</p>
                                <span class="badge bg-danger">Limited</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Newsletter Section -->
    <section id="newsletter" class="py-5 bg-dark text-white">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="text-center mb-5" data-aos="fade-up">
                        <h2 class="fw-light display-6 mb-3">Stay Connected</h2>
                        <p class="text-light opacity-90 lead">Be the first to know about new collections, exclusive releases, and expert knitting insights.</p>
                    </div>
                    <div class="card border-0 bg-transparent" data-aos="fade-up" data-aos-delay="200">
                        <div class="card-body p-0">
                            <livewire:subscribe-newsletter />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</x-app-layout>
