@php
    $heroImage = 'https://as2.ftcdn.net/v2/jpg/05/73/25/21/1000_F_573252161_2yB7QmX2ZtS5e1d5Yy0mPi3oJt4GtwqZ.jpg'; // Luxury textile texture
    $gallery = [
        'https://as2.ftcdn.net/v2/jpg/03/65/51/06/1000_F_365510635_E8b3EsXrTq7F4QyYxw0qBz1lWY0eH6gS.jpg', // Merino wool close-up
        'https://as2.ftcdn.net/v2/jpg/05/86/66/70/1000_F_586667041_7K5Z5B5oC8BzT1d0zWv0qPlrT3Jw2sS.jpg', // Cashmere texture
        'https://as2.ftcdn.net/v2/jpg/03/23/48/96/1000_F_323489628_C0jQH0QxWgB1p0ibKcJv8XoH8Yk4m0H0.jpg', // Silk blend
        'https://as2.ftcdn.net/v2/jpg/05/73/25/21/1000_F_573252161_2yB7QmX2ZtS5e1d5Yy0mPi3oJt4GtwqZ.jpg', // Premium yarn
    ];
    
    // Get active seasons for dynamic content
    $activeSeasons = App\Models\Season::where('is_active', true)
        ->orderBy('year')
        ->orderBy('half', 'desc') // AW before SS
        ->get();
    
    // Get featured categories for dynamic display
    $featuredCategories = App\Models\Category::where('sort_order', '>', 0)
        ->orderBy('sort_order')
        ->take(4)
        ->get();
    
    // Get latest items for collection preview
    $latestItems = App\Models\Item::with(['category', 'season'])
        ->where('is_active', true)
        ->latest()
        ->take(4)
        ->get();
@endphp

<x-app-layout>
    <!-- Hero Section -->
    <section class="hero-section position-relative overflow-hidden bg-dark text-white">
        <div class="hero-background">
            <img src="{{ $heroImage }}" alt="Luxury Textiles" class="hero-image">
            <div class="hero-overlay"></div>
        </div>
        <div class="container position-relative" style="z-index: 2;">
            <div class="row align-items-center" style="min-height: 90vh;">
                <div class="col-lg-7 py-5">
                    <div class="hero-content" data-aos="fade-up" data-aos-delay="200">
                        @if($activeSeasons->count() > 0)
                            <span class="badge bg-primary-subtle text-primary fw-semibold mb-4 px-3 py-2">
                                <i class="bi bi-stars me-2"></i>New Season Collections
                            </span>
                        @endif
                        <h1 class="display-3 fw-light mb-4 text-white">
                            The Yarn Store
                            <span class="d-block fw-normal fs-2 mt-2 text-light">Exceptional Fibres</span>
                        </h1>
                        <p class="lead mb-5 text-light opacity-90">
                            Discover the world's finest yarns from legendary Italian mills. Merino, cashmere, and silk blends 
                            crafted with generations of expertise. Every skein tells a story of luxury and tradition.
                        </p>
                        
                        <!-- Dynamic Season Collection Buttons -->
                        @if($activeSeasons->count() > 0)
                            <div class="mb-4">
                                <h6 class="text-light opacity-90 mb-3">Explore Our Collections:</h6>
                                <div class="d-flex gap-3 flex-wrap">
                                    @foreach($activeSeasons as $season)
                                        <a href="#collection-{{ $season->code }}" class="btn btn-primary btn-lg px-4 py-3 season-btn" 
                                           data-season="{{ $season->code }}">
                                            <i class="bi bi-collection me-2"></i>
                                            {{ $season->code }} Collection
                                            <small class="d-block opacity-75">{{ $season->label }}</small>
                                        </a>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                        
                        <div class="d-flex gap-3 flex-wrap">
                            <a href="#about" class="btn btn-outline-light btn-lg px-4 py-3">
                                <i class="bi bi-info-circle me-2"></i>Our Story
                            </a>
                            @if($activeSeasons->count() > 0)
                                <a href="#collections" class="btn btn-outline-light btn-lg px-4 py-3">
                                    <i class="bi bi-grid-3x3-gap me-2"></i>View All Collections
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="scroll-indicator">
            <div class="scroll-arrow"></div>
        </div>
    </section>

    <!-- Features Section -->
    <section id="features" class="py-5 bg-white">
        <div class="container">
            <div class="text-center mb-5" data-aos="fade-up">
                <h2 class="fw-light display-6 mb-3">Why The Yarn Store?</h2>
                <p class="text-muted lead">Where heritage meets innovation in every fibre</p>
            </div>
            <div class="row g-4">
                <div class="col-md-4" data-aos="fade-up" data-aos-delay="100">
                    <div class="feature-card text-center p-4 h-100">
                        <div class="feature-icon mb-4">
                            <i class="bi bi-award display-4 text-primary"></i>
                        </div>
                        <h5 class="fw-semibold mb-3">Heritage Quality</h5>
                        <p class="text-muted">Sourced from Italy's most prestigious mills, including Zegna Baruffa, with over 150 years of textile excellence.</p>
                    </div>
                </div>
                <div class="col-md-4" data-aos="fade-up" data-aos-delay="200">
                    <div class="feature-card text-center p-4 h-100">
                        <div class="feature-icon mb-4">
                            <i class="bi bi-palette2 display-4 text-primary"></i>
                        </div>
                        <h5 class="fw-semibold mb-3">Curated Palettes</h5>
                        <p class="text-muted">Seasonally curated colour stories that inspire and coordinate perfectly across your entire collection.</p>
                    </div>
                </div>
                <div class="col-md-4" data-aos="fade-up" data-aos-delay="300">
                    <div class="feature-card text-center p-4 h-100">
                        <div class="feature-icon mb-4">
                            <i class="bi bi-heart display-4 text-primary"></i>
                        </div>
                        <h5 class="fw-semibold mb-3">Personal Service</h5>
                        <p class="text-muted">Expert guidance from our team of textile specialists, ensuring you find the perfect yarn for every project.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section id="about" class="py-5 bg-light">
        <div class="container">
            <div class="row align-items-center g-5">
                <div class="col-lg-6" data-aos="fade-right">
                    <div class="about-image position-relative">
                        <div class="ratio ratio-4x3 rounded overflow-hidden shadow-lg">
                            <img src="{{ $gallery[0] }}" class="w-100 h-100 object-fit-cover" alt="Merino Wool">
                        </div>
                        <div class="floating-badge">
                            <span class="badge bg-primary px-3 py-2">Est. 2024</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6" data-aos="fade-left">
                    <h2 class="fw-light display-6 mb-4">A Legacy of Excellence</h2>
                    <p class="text-muted mb-4 lead">
                        The Yarn Store represents the pinnacle of textile craftsmanship. We partner with legendary Italian mills 
                        like Zegna Baruffa, whose expertise spans generations of luxury fibre production.
                    </p>
                    <p class="text-muted mb-4">
                        From the finest merino wool to the most luxurious cashmere blends, every yarn in our collection 
                        is carefully selected for its exceptional quality, beautiful hand, and timeless appeal.
                    </p>
                    <div class="row g-3">
                        <div class="col-6">
                            <div class="d-flex align-items-center gap-2">
                                <i class="bi bi-check-circle-fill text-success"></i>
                                <span class="small">Premium Italian Mills</span>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="d-flex align-items-center gap-2">
                                <i class="bi bi-check-circle-fill text-success"></i>
                                <span class="small">Sustainable Sourcing</span>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="d-flex align-items-center gap-2">
                                <i class="bi bi-check-circle-fill text-success"></i>
                                <span class="small">Expert Consultation</span>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="d-flex align-items-center gap-2">
                                <i class="bi bi-check-circle-fill text-success"></i>
                                <span class="small">Worldwide Shipping</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Dynamic Collections Section -->
    @if($activeSeasons->count() > 0)
        <section id="collections" class="py-5 bg-white">
            <div class="container">
                <div class="text-center mb-5" data-aos="fade-up">
                    <h2 class="fw-light display-6 mb-3">Seasonal Collections</h2>
                    <p class="text-muted lead">Discover our curated selection of the world's finest yarns by season</p>
                </div>
                
                @foreach($activeSeasons as $index => $season)
                    <div id="collection-{{ $season->code }}" class="collection-season mb-5" data-aos="fade-up" data-aos-delay="{{ ($index + 1) * 100 }}">
                        <div class="row align-items-center g-4 mb-4">
                            <div class="col-lg-6">
                                <h3 class="fw-light display-6 mb-3">{{ $season->code }} Collection</h3>
                                <h4 class="h5 text-muted mb-3">{{ $season->label }}</h4>
                                @if($season->starts_on && $season->ends_on)
                                    <p class="text-muted mb-3">
                                        <i class="bi bi-calendar-event me-2"></i>
                                        Available: {{ \Carbon\Carbon::parse($season->starts_on)->format('M Y') }} - {{ \Carbon\Carbon::parse($season->ends_on)->format('M Y') }}
                                    </p>
                                @endif
                                <p class="text-muted mb-4">
                                    {{ $season->description ?? 'Experience the ' . strtolower($season->half === 'AW' ? 'Autumn/Winter' : 'Spring/Summer') . ' collection featuring our most luxurious fibres and curated colour palettes.' }}
                                </p>
                                <a href="#" class="btn btn-primary btn-lg px-4 py-3">
                                    <i class="bi bi-arrow-right me-2"></i>Explore {{ $season->code }}
                                </a>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-3">
                                    @foreach($latestItems->take(2) as $item)
                                        <div class="col-6">
                                            <div class="collection-preview-card position-relative overflow-hidden rounded shadow-sm">
                                                <div class="ratio ratio-1x1">
                                                    <img src="{{ $gallery[array_rand($gallery)] }}" class="w-100 h-100 object-fit-cover" alt="{{ $item->name }}">
                                                </div>
                                                <div class="collection-preview-overlay">
                                                    <div class="collection-preview-content text-center text-white">
                                                        <h6 class="fw-semibold mb-1">{{ $item->name }}</h6>
                                                        <small class="opacity-90">{{ $item->category->name ?? 'Collection' }}</small>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </section>
    @endif

    <!-- Newsletter Section -->
    <section id="newsletter" class="py-5 bg-dark text-white">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="text-center mb-5" data-aos="fade-up">
                        <h2 class="fw-light display-6 mb-3">Stay Connected</h2>
                        <p class="text-light opacity-90 lead">Be the first to know about new collections, exclusive releases, and expert knitting insights.</p>
                    </div>
                    <div class="card border-0 bg-transparent" data-aos="fade-up" data-aos-delay="200">
                        <div class="card-body p-0">
                            <livewire:subscribe-newsletter />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</x-app-layout>
