@php
    // Get active seasons for dynamic content
    $activeSeasons = App\Models\Season::where('is_active', true)
        ->orderBy('year')
        ->orderBy('half', 'desc') // AW before SS
        ->get();
    
    // Use the first active season's image for hero, or fallback to a default
    $heroImage = $activeSeasons->first()?->image_path ?? 'https://as2.ftcdn.net/v2/jpg/05/73/25/21/1000_F_573252161_2yB7QmX2ZtS5e1d5Yy0mPi3oJt4GtwqZ.jpg';
    
    // Get featured categories for dynamic display
    $featuredCategories = App\Models\Category::where('sort_order', '>', 0)
        ->orderBy('sort_order')
        ->take(4)
        ->get();
    
    // Get latest items for collection preview
    $latestItems = App\Models\Item::with(['category', 'season'])
        ->where('is_active', true)
        ->latest()
        ->take(4)
        ->get();
@endphp

<x-app-layout>
    <!-- Hero Section -->
    <section class="hero-section position-relative overflow-hidden bg-dark text-white">
        <div class="hero-background">
            <img src="{{ $heroImage }}" alt="Luxury Textiles" class="hero-image">
            <div class="hero-overlay"></div>
                        </div>
        <div class="container position-relative" style="z-index: 2;">
            <div class="row align-items-center" style="min-height: 90vh;">
                <div class="col-lg-7 py-5">
                    <div class="hero-content" data-aos="fade-up" data-aos-delay="200">
                        @if($activeSeasons->count() > 0)
                            <span class="badge bg-primary-subtle text-primary fw-semibold mb-4 px-3 py-2 rounded-pill">
                                <i class="bi bi-leaf me-2"></i>Now Featuring: {{ $activeSeasons->first()->label }}
                            </span>
                        @endif
                        <h1 class="display-3 fw-light mb-4 text-white">
                            The Yarn Store
                            <span class="d-block fw-normal fs-2 mt-2 text-light">Luxury yarns, thoughtfully sourced</span>
                        </h1>
                        <p class="lead mb-5 text-light opacity-90">
                            Discover soft, breathable and beautiful fibres from the world’s leading mills. Merino, cashmere and silk blends curated with care, colour and comfort in mind.
                        </p>
                        
                        <!-- Dynamic Season Collection Buttons -->
                        @if($activeSeasons->count() > 0)
                            <div class="mb-4">
                                <h6 class="text-light opacity-90 mb-3">Explore Our Collections:</h6>
                                <div class="d-flex gap-3 flex-wrap">
                                    @foreach($activeSeasons as $season)
                                        <a href="{{ route('collection.detail', $season->code) }}" class="btn btn-primary btn-lg px-4 py-3 rounded-pill season-btn" 
                                           data-season="{{ $season->code }}">
                                            <i class="bi bi-collection me-2"></i>
                                            {{ $season->code }}
                                            <small class="d-block opacity-75">{{ $season->label }}</small>
                                        </a>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                    </div>
                                        </div>
                                        </div>
                                    </div>
        <div class="scroll-indicator">
            <div class="scroll-arrow"></div>
        </div>
    </section>

    <!-- Features Section -->
    <section id="features" class="py-5 bg-light">
        <div class="container">
            <div class="text-center mb-5" data-aos="fade-up">
                <h2 class="fw-light display-6 mb-3">Why The Yarn Store?</h2>
                <p class="text-muted lead">Where heritage meets innovation in every fibre</p>
            </div>
            <div class="row g-4">
                <div class="col-md-4" data-aos="fade-up" data-aos-delay="100">
                    <div class="feature-card text-center p-4 h-100 rounded-4 shadow-sm bg-white">
                        <div class="feature-icon mb-4 rounded-circle bg-primary-subtle d-inline-flex align-items-center justify-content-center" style="width:72px;height:72px;">
                            <i class="bi bi-award fs-2 text-primary"></i>
                        </div>
                        <h5 class="fw-semibold mb-3">Heritage Quality</h5>
                        <p class="text-muted">Yarns from the most prestigious mills with generations of excellence and care in every fibre.</p>
                    </div>
                </div>
                <div class="col-md-4" data-aos="fade-up" data-aos-delay="200">
                    <div class="feature-card text-center p-4 h-100 rounded-4 shadow-sm bg-white">
                        <div class="feature-icon mb-4 rounded-circle bg-primary-subtle d-inline-flex align-items-center justify-content-center" style="width:72px;height:72px;">
                            <i class="bi bi-palette2 fs-2 text-primary"></i>
                        </div>
                        <h5 class="fw-semibold mb-3">Curated Palettes</h5>
                        <p class="text-muted">Seasonal colour stories that feel fresh, wearable and easy to love.</p>
                    </div>
                </div>
                <div class="col-md-4" data-aos="fade-up" data-aos-delay="300">
                    <div class="feature-card text-center p-4 h-100 rounded-4 shadow-sm bg-white">
                        <div class="feature-icon mb-4 rounded-circle bg-primary-subtle d-inline-flex align-items-center justify-content-center" style="width:72px;height:72px;">
                            <i class="bi bi-heart fs-2 text-primary"></i>
                        </div>
                        <h5 class="fw-semibold mb-3">Personal Service</h5>
                        <p class="text-muted">Friendly, expert guidance to help you choose yarns that feel perfect for your project.</p>
                    </div>
                </div>
            </div>
                                </div>
    </section>

    <!-- About Section -->
    <section class="about-section py-5 bg-white">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6" data-aos="fade-right">
                    <div class="about-content">
                        <span class="badge bg-primary-subtle text-primary fw-semibold mb-4 px-3 py-2">
                            <i class="bi bi-award me-2"></i>Industry Leaders
                        </span>
                        
                        <h2 class="fw-light display-5 mb-4">Meet Our Spinning Partners</h2>
                        
                        <p class="lead mb-4">
                            Robert Todd is proud to represent industry leading Italian and Chinese spinning mills, with long term relationships forged by pioneering spirit and commitment to sustainability.
                        </p>
                        
                        <p class="mb-4">
                            We work exclusively with the world's finest spinners, including Zegna Baruffa Lane Borgosesia, Marchi Fildi & Filidea, Pinori Filati, Ecafil Best, Filati Naturali, Ilaria, and Filitaly. Each partner brings decades of expertise and innovation to our yarn collections.
                        </p>
                        
                        <div class="d-flex gap-3 flex-wrap">
                            <a href="{{ route('collections') }}" class="btn btn-primary btn-lg px-4 py-3 rounded-pill">
                                <i class="bi bi-collection me-2"></i>Explore Collections
                            </a>
                            <a href="#partners" class="btn btn-outline-primary btn-lg px-4 py-3 rounded-pill">
                                <i class="bi bi-building me-2"></i>Learn More
                            </a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6" data-aos="fade-left">
                    <div class="about-image text-center">
                        @if($activeSeasons->first() && $activeSeasons->first()->image_path)
                            <img src="{{ $activeSeasons->first()->image_path }}" class="img-fluid rounded-4 shadow" alt="Luxury Yarn Collection">
                        @else
                            <div class="about-placeholder rounded-4 shadow">
                                <i class="bi bi-award display-1 text-primary"></i>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Partners Section -->
    <section id="partners" class="py-5 bg-light">
        <div class="container">
            <div class="text-center mb-5" data-aos="fade-up">
                <h2 class="fw-light display-5 mb-3">Our Spinning Partners</h2>
                <p class="text-muted lead">Discover the world-class mills behind our exceptional yarn collections</p>
                                </div>

            <div class="row g-4">
                <div class="col-lg-6" data-aos="fade-up" data-aos-delay="100">
                    <div class="partner-card h-100 p-4 rounded-4 shadow-sm border-0">
                        <div class="partner-header mb-3">
                            <h4 class="fw-semibold text-primary mb-2">Zegna Baruffa Lane Borgosesia</h4>
                            <p class="text-muted small mb-0">Founded 1850 • Prato, Italy</p>
                        </div>
                        <p class="mb-3">
                            A powerhouse of Italian textiles and one of the last Italian mills with vertical production. World renowned for extrafine merino and merino blends, their Zegna Cashwool remains the most recognisable extrafine merino on the market.
                        </p>
                        <div class="partner-specialties">
                            <span class="badge bg-light text-dark me-1 mb-1">Extrafine Merino</span>
                            <span class="badge bg-light text-dark me-1 mb-1">Cashmere</span>
                            <span class="badge bg-light text-dark me-1 mb-1">Silk</span>
                            <span class="badge bg-light text-dark me-1 mb-1">Fancy Yarns</span>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-6" data-aos="fade-up" data-aos-delay="200">
                    <div class="partner-card h-100 p-4 rounded-4 shadow-sm border-0">
                        <div class="partner-header mb-3">
                            <h4 class="fw-semibold text-primary mb-2">Marchi Fildi & Filidea</h4>
                            <p class="text-muted small mb-0">Global Leader • Italy, Turkey, Brazil</p>
                        </div>
                        <p class="mb-3">
                            Specialists in sustainable and innovative yarns with three distinct collections. Home to ECOTEC® technology and leaders in cotton spinning, offering GOTS certified cotton and RWS wool.
                        </p>
                        <div class="partner-specialties">
                            <span class="badge bg-light text-dark me-1 mb-1">Cotton</span>
                            <span class="badge bg-light text-dark me-1 mb-1">RWS Wool</span>
                            <span class="badge bg-light text-dark me-1 mb-1">Silk</span>
                            <span class="badge bg-light text-dark me-1 mb-1">Recycled</span>
                        </div>
                    </div>
                                </div>

                <div class="col-lg-6" data-aos="fade-up" data-aos-delay="300">
                    <div class="partner-card h-100 p-4 rounded-4 shadow-sm border-0">
                        <div class="partner-header mb-3">
                            <h4 class="fw-semibold text-primary mb-2">Pinori Filati</h4>
                            <p class="text-muted small mb-0">Since 1970 • Prato, Italy</p>
                        </div>
                        <p class="mb-3">
                            Passionate about artisanal and innovative fancy yarns. Autumn/Winter emphasizes Alpaca with natural shades, while Spring/Summer focuses on sustainability with their 'Recy' range including recycled cotton and denim.
                        </p>
                        <div class="partner-specialties">
                            <span class="badge bg-light text-dark me-1 mb-1">Alpaca</span>
                            <span class="badge bg-light text-dark me-1 mb-1">Boucles</span>
                            <span class="badge bg-light text-dark me-1 mb-1">Recycled</span>
                            <span class="badge bg-light text-dark me-1 mb-1">Space Dyes</span>
                        </div>
                    </div>
                                </div>

                <div class="col-lg-6" data-aos="fade-up" data-aos-delay="400">
                    <div class="partner-card h-100 p-4 rounded-4 shadow-sm border-0">
                        <div class="partner-header mb-3">
                            <h4 class="fw-semibold text-primary mb-2">Ecafil Best</h4>
                            <p class="text-muted small mb-0">70+ Years • Tuscany, Italy</p>
                        </div>
                        <p class="mb-3">
                            Renowned for quality and innovative technologies including their patented ARYA® air spinning technology. Specialists in Mohair, Wool, and Alpaca with sustainable alternatives and handknitting yarns.
                        </p>
                        <div class="partner-specialties">
                            <span class="badge bg-light text-dark me-1 mb-1">Mohair</span>
                            <span class="badge bg-light text-dark me-1 mb-1">Alpaca</span>
                            <span class="badge bg-light text-dark me-1 mb-1">Handknitting</span>
                            <span class="badge bg-light text-dark me-1 mb-1">ARYA Technology</span>
                        </div>
                    </div>
                </div>
                                </div>

            <div class="text-center mt-5" data-aos="fade-up">
                <a href="{{ route('collections') }}" class="btn btn-primary btn-lg px-5 py-3 rounded-pill">
                    <i class="bi bi-collection me-2"></i>Explore Our Yarn Collections
                </a>
            </div>
        </div>
    </section>

    <!-- Dynamic Collections Section -->
    @if($activeSeasons->count() > 0)
        <section id="collections" class="py-5 bg-white section-divider">
            <div class="container">
                <div class="text-center mb-5" data-aos="fade-up">
                    <h2 class="fw-light display-6 mb-3">Seasonal Collections</h2>
                    <p class="text-muted lead">Discover our curated selection of the world's finest yarns by season</p>
                                </div>

                @foreach($activeSeasons as $index => $season)
                    <div id="collection-{{ $season->code }}" class="collection-season mb-5" data-aos="fade-up" data-aos-delay="{{ ($index + 1) * 100 }}">
                        <div class="row align-items-center g-4 mb-4">
                            <div class="col-lg-6">
                                <h3 class="fw-light display-6 mb-3">{{ $season->label }}</h3>
                                <h4 class="h5 text-muted mb-3">{{ $season->label }}</h4>
                                @if($season->starts_on && $season->ends_on)
                                    <p class="text-muted mb-3">
                                        <i class="bi bi-calendar-event me-2"></i>
                                        Available: {{ \Carbon\Carbon::parse($season->starts_on)->format('M Y') }} - {{ \Carbon\Carbon::parse($season->ends_on)->format('M Y') }}
                                    </p>
                                @endif
                                <p class="text-muted mb-4">
                                    {{ $season->description ?? 'Experience the ' . strtolower($season->half === 'AW' ? 'Autumn/Winter' : 'Spring/Summer') . ' collection featuring our most luxurious fibres and curated colour palettes.' }}
                                </p>
                                <a href="{{ route('collection.detail', $season->code) }}" class="btn btn-primary btn-lg px-4 py-3 rounded-pill">
                                    <i class="bi bi-arrow-right me-2"></i>Explore {{ $season->code }}
                                </a>
                            </div>
                            <div class="col-lg-6">
                                <div class="collection-preview-image position-relative overflow-hidden rounded shadow-sm">
                                    <div class="ratio ratio-16x9">
                                        @if($season->image_path)
                                            <img src="{{ $season->image_path }}" class="w-100 h-100 object-fit-cover" alt="{{ $season->code }} Collection">
                                        @else
                                            <div class="w-100 h-100 bg-light d-flex align-items-center justify-content-center">
                                                <i class="bi bi-{{ $season->half === 'AW' ? 'snow' : 'sun' }} display-1 text-muted"></i>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="collection-preview-overlay">
                                        <div class="collection-preview-content text-center text-white">
                                            <h6 class="fw-semibold mb-1">{{ $season->code }} Collection</h6>
                                            <small class="opacity-90">{{ $season->label }}</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </section>
    @endif

    <!-- Newsletter Section -->
    <section id="newsletter" class="py-5 bg-dark text-white">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="text-center mb-5" data-aos="fade-up">
                        <h2 class="fw-light display-6 mb-3">Stay Connected</h2>
                        <p class="text-light opacity-90 lead">Be the first to know about new collections, exclusive releases, and expert knitting insights.</p>
                    </div>
                    <div class="card border-0 bg-transparent" data-aos="fade-up" data-aos-delay="200">
                        <div class="card-body p-0">
                            <livewire:subscribe-newsletter />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</x-app-layout>
