@php
    $heroImage = 'https://as2.ftcdn.net/v2/jpg/02/72/40/63/1000_F_272406345_jn6t16d1GQ3aB0ItAx8wDGgxxjz2F2oJ.jpg'; // Adobe Stock sample placeholder
    $gallery = [
        'https://as2.ftcdn.net/v2/jpg/05/73/25/21/1000_F_573252161_2yB7QmX2ZtS5e1d5Yy0mPi3oJt4GtwqZ.jpg',
        'https://as2.ftcdn.net/v2/jpg/03/65/51/06/1000_F_365510635_E8b3EsXrTq7F4QyYxw0qBz1lWY0eH6gS.jpg',
        'https://as2.ftcdn.net/v2/jpg/05/86/66/70/1000_F_586667041_7K5Z5B5oC8BzT1Vd0zWv0qPlrT3Jw2sS.jpg',
        'https://as2.ftcdn.net/v2/jpg/03/23/48/96/1000_F_323489628_C0jQH0QxWgB1p0ibKcJv8XoH8Yk4m0H0.jpg',
    ];
@endphp

<x-app-layout>
    <section class="position-relative overflow-hidden bg-dark text-white">
        <img src="{{ $heroImage }}" alt="Hero" class="position-absolute top-0 start-0 w-100 h-100 object-fit-cover opacity-25">
        <div class="container position-relative" style="z-index: 2;">
            <div class="row align-items-center" style="min-height: 70vh;">
                <div class="col-lg-7 py-5">
                    <span class="badge bg-primary-subtle text-primary fw-semibold mb-3"><i class="bi bi-stars me-1"></i> New Season</span>
                    <h1 class="display-4 fw-bold mb-3">Thoughtfully Crafted Textiles</h1>
                    <p class="lead mb-4">Premium materials, timeless palettes, and considered details. Discover our latest season and build your story in colour and texture.</p>
                    <div class="d-flex gap-2">
                        <a href="#features" class="btn btn-primary btn-lg"><i class="bi bi-bag-heart me-2"></i>Explore</a>
                        <a href="#newsletter" class="btn btn-outline-light btn-lg"><i class="bi bi-envelope-paper-heart me-2"></i>Get updates</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="features" class="py-5 bg-light">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="fw-bold">Why choose us</h2>
                <p class="text-muted">Modern design, responsible sourcing, and dependable service.</p>
            </div>
            <div class="row g-4">
                <div class="col-md-4">
                    <div class="card h-100 shadow-sm border-0">
                        <div class="card-body p-4">
                            <div class="display-6 text-primary mb-3"><i class="bi bi-palette2"></i></div>
                            <h5 class="card-title">Refined colour stories</h5>
                            <p class="card-text text-muted">Curated palettes across seasons to simplify assortment planning and merchandising.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card h-100 shadow-sm border-0">
                        <div class="card-body p-4">
                            <div class="display-6 text-primary mb-3"><i class="bi bi-flower3"></i></div>
                            <h5 class="card-title">Natural, premium fibres</h5>
                            <p class="card-text text-muted">Merino, cashmere and blends selected for feel, durability, and responsible provenance.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card h-100 shadow-sm border-0">
                        <div class="card-body p-4">
                            <div class="display-6 text-primary mb-3"><i class="bi bi-truck"></i></div>
                            <h5 class="card-title">Reliable fulfilment</h5>
                            <p class="card-text text-muted">Efficient order processing and transparent status updates from sampling to delivery.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="about" class="py-5">
        <div class="container">
            <div class="row align-items-center g-4">
                <div class="col-lg-6">
                    <div class="ratio ratio-16x9 rounded overflow-hidden shadow-sm">
                        <img src="{{ $gallery[0] }}" class="w-100 h-100 object-fit-cover" alt="Studio">
                    </div>
                </div>
                <div class="col-lg-6">
                    <h2 class="fw-bold mb-3">Design-led. Supply-smart.</h2>
                    <p class="text-muted mb-3">We pair an editorial eye with practical production knowledge—bridging brand vision and factory realities. From yarn selection to final colour checks, your product is cared for at every stage.</p>
                    <ul class="list-unstyled text-muted">
                        <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Seasonal colour harmonies for easy mix-and-match</li>
                        <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Flexible MOQs and dependable lead times</li>
                        <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Transparent communication from sample to bulk</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <section id="gallery" class="py-5 bg-light">
        <div class="container">
            <div class="text-center mb-4">
                <h2 class="fw-bold">Material & colour inspiration</h2>
                <p class="text-muted">A glimpse from our studio mood boards.</p>
            </div>
            <div class="row g-3">
                @foreach($gallery as $url)
                    <div class="col-6 col-md-3">
                        <div class="ratio ratio-1x1 rounded overflow-hidden shadow-sm">
                            <img src="{{ $url }}" class="w-100 h-100 object-fit-cover" alt="Mood image">
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>

    <section id="newsletter" class="py-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div class="card border-0 shadow-sm">
                        <div class="card-body p-4 p-md-5">
                            <div class="d-flex align-items-start gap-3 mb-3">
                                <div class="fs-2 text-primary"><i class="bi bi-envelope-paper-heart"></i></div>
                                <div>
                                    <h3 class="fw-bold mb-1">Join our colour notes</h3>
                                    <p class="text-muted mb-0">Occasional updates on palettes, materials, and launches. No spam, ever.</p>
                                </div>
                            </div>
                            <livewire:subscribe-newsletter />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</x-app-layout>
