<div class="card shadow-sm">
    <div class="card-body">
        <form wire:submit.prevent="import" class="d-flex flex-column flex-md-row align-items-md-center gap-2" enctype="multipart/form-data">
            <input type="file" wire:model="pdf" accept="application/pdf" class="form-control" style="max-width:320px">
            <button type="submit" class="btn btn-outline-secondary" wire:loading.attr="disabled" wire:target="pdf,import">Import colourways PDF</button>
        </form>
        @error('pdf') <div class="text-danger small mt-2">{{ $message }}</div> @enderror
        <div class="small mt-2">
            <span wire:loading wire:target="pdf,import" class="text-muted">Uploading/Parsing…</span>
        </div>
        <small class="text-muted d-block mt-2">Max 50MB. Parsed JSON is written to storage/logs/laravel.log for now.</small>
    </div>
</div>

