<div class="card shadow-sm">
    <div class="card-body">
        <h5 class="mb-3">Import Colourways PDF</h5>
        
        <!-- Test button to verify component is working -->
        <button type="button" class="btn btn-outline-info btn-sm mb-3" wire:click="testConnection">
            Test Component Connection
        </button>
        
        <!-- Check file state button -->
        <button type="button" class="btn btn-outline-warning btn-sm mb-3 ms-2" wire:click="checkFileState">
            Check File State
        </button>
        <form wire:submit.prevent="import" enctype="multipart/form-data">
            <div class="mb-3">
                <label for="pdfFile" class="form-label">Upload PDF</label>
                <input type="file" class="form-control @error('pdf') is-invalid @enderror" id="pdfFile" wire:model="pdf" accept="application/pdf">
                @error('pdf') <div class="invalid-feedback">{{ $message }}</div> @enderror
            </div>
            <button type="submit" class="btn btn-primary rounded-pill"
                    wire:loading.attr="disabled"
                    wire:target="import">
                <span wire:loading wire:target="import">Uploading/Parsing...</span>
                <span wire:loading.remove wire:target="import">Import Colourways PDF</span>
            </button>
        </form>
        
        <div wire:loading wire:target="pdf" class="mt-3 text-info">
            <i class="bi bi-cloud-upload"></i> Uploading file...
        </div>
        
        <small class="text-muted d-block mt-2">Max 50MB. Parsed JSON is written to storage/logs/laravel.log for now.</small>
        
        <!-- Debug info -->
        <div class="mt-3 p-2 bg-light rounded">
            <small class="text-muted">
                <strong>Debug:</strong><br>
                Component ID: <span id="component-id">{{ $this->getId() }}</span><br>
                File selected: <span id="file-selected">No</span>
            </small>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const fileInput = document.getElementById('pdfFile');
    const fileSelectedSpan = document.getElementById('file-selected');
    
    if (fileInput) {
        fileInput.addEventListener('change', function(e) {
            console.log('File input changed:', e.target.files[0]);
            if (e.target.files[0]) {
                fileSelectedSpan.textContent = e.target.files[0].name + ' (' + (e.target.files[0].size / 1024 / 1024).toFixed(2) + ' MB)';
            } else {
                fileSelectedSpan.textContent = 'No';
            }
        });
    }
    
    // Debug form submission
    const form = document.querySelector('form[wire\\:submit\\.prevent="import"]');
    if (form) {
        form.addEventListener('submit', function(e) {
            console.log('Form submit event triggered');
        });
    }
});
</script>

