<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('order_number', 30)->unique();
            $table->foreignId('customer_id')->constrained()->restrictOnDelete();
            $table->string('status', 30)->default('draft');
            $table->text('notes')->nullable();
            $table->string('zoho_invoice_number', 100)->unique()->nullable();
            $table->char('currency', 3)->default('GBP');
            $table->bigInteger('totals_estimated_minor')->default(0);
            $table->bigInteger('totals_final_minor')->default(0);
            $table->timestampTz('placed_at')->nullable();
            $table->timestampTz('invoice_sent_at')->nullable();
            $table->timestampTz('fulfilled_at')->nullable();

            // Billing snapshot
            $table->string('bill_name', 200)->nullable();
            $table->string('bill_line1', 200)->nullable();
            $table->string('bill_line2', 200)->nullable();
            $table->string('bill_city', 120)->nullable();
            $table->string('bill_region', 120)->nullable();
            $table->string('bill_postcode', 20)->nullable();
            $table->char('bill_country_code', 2)->nullable();
            $table->string('bill_phone', 50)->nullable();

            // Shipping snapshot
            $table->string('ship_name', 200)->nullable();
            $table->string('ship_line1', 200)->nullable();
            $table->string('ship_line2', 200)->nullable();
            $table->string('ship_city', 120)->nullable();
            $table->string('ship_region', 120)->nullable();
            $table->string('ship_postcode', 20)->nullable();
            $table->char('ship_country_code', 2)->nullable();
            $table->string('ship_phone', 50)->nullable();

            $table->timestamps();

            // Indexes
            $table->index('customer_id');
            $table->index('status');
            $table->index('placed_at');
        });

        // PostgreSQL CHECK constraints (only for PostgreSQL)
        if (DB::connection()->getDriverName() === 'pgsql') {
            DB::statement("ALTER TABLE orders ADD CONSTRAINT check_status CHECK (status IN ('draft', 'estimate_sent', 'in_production', 'weighed', 'invoice_sent', 'fulfilled', 'cancelled'))");
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
