<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('receipt_groups', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable(); // Optional name for the group
            $table->text('description')->nullable(); // Optional description
            $table->enum('grouping_method', ['manual', 'ai_auto', 'ai_suggested'])->default('manual');
            $table->decimal('confidence_score', 5, 2)->nullable(); // AI confidence in grouping
            $table->text('grouping_reason')->nullable(); // Explanation for why receipts were grouped
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('receipt_groups');
    }
};