<div class="min-h-screen bg-gradient-to-br from-primary-50 via-accent-50 to-primary-100">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Header -->
        <div class="text-center mb-12">
            <h1 class="text-4xl font-bold font-heading text-neutral-900 mb-4 tracking-heading">
                Wellness Library
            </h1>
            <p class="text-xl text-neutral-600 max-w-2xl mx-auto leading-relaxed">
                Discover guided sessions, meditation tracks, and wellness content to support your journey.
            </p>
        </div>

        <!-- Search and Filters -->
        <div class="bg-white rounded-2xl shadow-md p-6 mb-8">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-4">
                <!-- Search -->
                <div class="lg:col-span-2">
                    <label for="search" class="block text-sm font-medium text-neutral-700 mb-2">Search</label>
                    <div class="relative">
                        <input 
                            wire:model.live.debounce.300ms="search"
                            type="text" 
                            id="search"
                            placeholder="Search tracks, descriptions, or tags..."
                            class="w-full rounded-full border-neutral-200 focus:border-primary-400 focus:ring-primary-200 px-4 py-2 transition-colors"
                        >
                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center">
                            <svg class="h-5 w-5 text-neutral-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                        </div>
                    </div>
                </div>

                <!-- Category Filter -->
                <div>
                    <label for="category" class="block text-sm font-medium text-neutral-700 mb-2">Category</label>
                    <select 
                        wire:model.live="selectedCategory"
                        id="category"
                        class="w-full rounded-full border-neutral-200 focus:border-primary-400 focus:ring-primary-200 px-4 py-2 transition-colors"
                    >
                        <option value="">All Categories</option>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}">{{ $category->name }}</option>
                        @endforeach
                    </select>
                </div>

                <!-- Difficulty Filter -->
                <div>
                    <label for="difficulty" class="block text-sm font-medium text-neutral-700 mb-2">Difficulty</label>
                    <select 
                        wire:model.live="selectedDifficulty"
                        id="difficulty"
                        class="w-full rounded-full border-neutral-200 focus:border-primary-400 focus:ring-primary-200 px-4 py-2 transition-colors"
                    >
                        <option value="">All Levels</option>
                        <option value="beginner">Beginner</option>
                        <option value="intermediate">Intermediate</option>
                        <option value="advanced">Advanced</option>
                    </select>
                </div>

                <!-- Voice Filter -->
                <div>
                    <label for="voice" class="block text-sm font-medium text-neutral-700 mb-2">Voice</label>
                    <select 
                        wire:model.live="selectedVoice"
                        id="voice"
                        class="w-full rounded-full border-neutral-200 focus:border-primary-400 focus:ring-primary-200 px-4 py-2 transition-colors"
                    >
                        <option value="">All Voices</option>
                        <option value="male">Male</option>
                        <option value="female">Female</option>
                        <option value="neutral">Neutral</option>
                    </select>
                </div>
            </div>

            <!-- Clear Filters -->
            @if($search || $selectedCategory || $selectedDifficulty || $selectedVoice)
                <div class="mt-4 text-center">
                    <button 
                        wire:click="clearFilters"
                        class="inline-flex items-center px-4 py-2 text-sm font-medium text-neutral-600 bg-neutral-100 hover:bg-neutral-200 rounded-full transition-colors"
                    >
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                        Clear Filters
                    </button>
                </div>
            @endif
        </div>

        <!-- Results Count and Sort -->
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6">
            <div class="text-neutral-600 mb-4 sm:mb-0">
                Showing {{ $tracks->firstItem() ?? 0 }} to {{ $tracks->lastItem() ?? 0 }} of {{ $tracks->total() }} tracks
            </div>
            
            <div class="flex items-center space-x-2">
                <span class="text-sm text-neutral-600">Sort by:</span>
                <button 
                    wire:click="toggleSort('title')"
                    class="px-3 py-1 text-sm rounded-full transition-colors {{ $sortBy === 'title' ? 'bg-primary-100 text-primary-700' : 'bg-neutral-100 text-neutral-600 hover:bg-neutral-200' }}"
                >
                    Title
                    @if($sortBy === 'title')
                        <svg class="inline w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="{{ $sortOrder === 'asc' ? 'M5 15l7-7 7 7' : 'M19 9l-7 7-7-7' }}"></path>
                        </svg>
                    @endif
                </button>
                <button 
                    wire:click="toggleSort('rating')"
                    class="px-3 py-1 text-sm rounded-full transition-colors {{ $sortBy === 'rating' ? 'bg-primary-100 text-primary-700' : 'bg-neutral-100 text-neutral-600 hover:bg-neutral-200' }}"
                >
                    Rating
                    @if($sortBy === 'rating')
                        <svg class="inline w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="{{ $sortOrder === 'asc' ? 'M5 15l7-7 7 7' : 'M19 9l-7 7-7-7' }}"></path>
                        </svg>
                    @endif
                </button>
                <button 
                    wire:click="toggleSort('duration')"
                    class="px-3 py-1 text-sm rounded-full transition-colors {{ $sortBy === 'duration' ? 'bg-primary-100 text-primary-700' : 'bg-neutral-100 text-neutral-600 hover:bg-neutral-200' }}"
                >
                    Duration
                    @if($sortBy === 'duration')
                        <svg class="inline w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="{{ $sortOrder === 'asc' ? 'M5 15l7-7 7 7' : 'M19 9l-7 7-7-7' }}"></path>
                        </svg>
                    @endif
                </button>
            </div>
        </div>

        <!-- Tracks Grid -->
        @if($tracks->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
                @foreach($tracks as $track)
                    <div class="bg-white rounded-2xl shadow-md hover:shadow-lg transition-all duration-300 transform hover:translate-y-[-2px] hover:scale-[1.01] overflow-hidden">
                        <!-- Track Image Placeholder -->
                        <div class="h-48 bg-gradient-to-br from-primary-100 to-accent-100 flex items-center justify-center">
                            <svg class="h-16 w-16 text-primary-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19V6l12-3v13M9 19c0 1.105-1.343 2-3 2s-3-.895-3-2 1.343-2 3-2 3 .895 3 2zm12-3c0 1.105-1.343 2-3 2s-3-.895-3-2 1.343-2 3-2 3 .895 3 2zM9 10l12-3"></path>
                            </svg>
                        </div>

                        <!-- Track Info -->
                        <div class="p-6">
                            <!-- Category Badge -->
                            <div class="mb-3">
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-primary-100 text-primary-800">
                                    {{ $track->category->name }}
                                </span>
                            </div>

                            <!-- Title -->
                            <h3 class="text-lg font-semibold font-heading text-neutral-900 mb-2 line-clamp-2">
                                {{ $track->title }}
                            </h3>

                            <!-- Description -->
                            @if($track->description)
                                <p class="text-neutral-600 text-sm mb-4 line-clamp-2">
                                    {{ $track->description }}
                                </p>
                            @endif

                            <!-- Meta Info -->
                            <div class="flex items-center justify-between text-sm text-neutral-500 mb-4">
                                <span class="flex items-center">
                                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                    {{ $track->duration ? gmdate('i:s', $track->duration) : 'N/A' }}
                                </span>
                                <span class="flex items-center">
                                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z"></path>
                                    </svg>
                                    {{ number_format($track->rating, 1) }}
                                </span>
                            </div>

                            <!-- Difficulty and Voice -->
                            <div class="flex items-center justify-between text-xs text-neutral-500 mb-4">
                                <span class="capitalize">{{ $track->difficulty_level }}</span>
                                <span class="capitalize">{{ $track->voice_type }}</span>
                            </div>

                            <!-- Play Button -->
                            <a 
                                href="{{ route('library.track', $track->slug) }}"
                                class="w-full inline-flex items-center justify-center px-4 py-2 border border-transparent text-sm font-medium rounded-full text-white bg-gradient-to-r from-primary-400 to-primary-500 hover:from-primary-500 hover:to-primary-600 transition-all duration-300 transform hover:scale-105"
                            >
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14.828 14.828a4 4 0 01-5.656 0M9 10h1m4 0h1m-6 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                Listen Now
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>

            <!-- Pagination -->
            <div class="mt-12">
                {{ $tracks->links() }}
            </div>
        @else
            <!-- No Results -->
            <div class="text-center py-16">
                <div class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-neutral-100 mb-4">
                    <svg class="h-8 w-8 text-neutral-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"></path>
                    </svg>
                </div>
                <h3 class="text-lg font-medium text-neutral-900 mb-2">No tracks found</h3>
                <p class="text-neutral-600 mb-6">Try adjusting your search or filters to find what you're looking for.</p>
                <button 
                    wire:click="clearFilters"
                    class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-full text-white bg-gradient-to-r from-primary-400 to-primary-500 hover:from-primary-500 hover:to-primary-600 transition-colors"
                >
                    Clear All Filters
                </button>
            </div>
        @endif
    </div>
</div>
