<x-guest-layout>
    <div class="relative overflow-hidden bg-white">
        <!-- Hero section -->
        <div class="relative pt-6 pb-16 sm:pb-24">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center">
                    <h1 class="text-4xl tracking-tight font-extrabold text-gray-900 sm:text-5xl md:text-6xl">
                        <span class="block">Transform Your Mind</span>
                        <span class="block text-indigo-600">With Hypno AI</span>
                    </h1>
                    <p class="mt-3 max-w-md mx-auto text-base text-gray-500 sm:text-lg md:mt-5 md:text-xl md:max-w-3xl">
                        Experience personalized hypnosis sessions powered by AI. Reduce stress, improve sleep, build confidence, and achieve your goals with our scientifically-backed approach.
                    </p>
                    <div class="mt-5 max-w-md mx-auto sm:flex sm:justify-center md:mt-8">
                        <div class="rounded-md shadow">
                            <a href="{{ route('library.index') }}" class="w-full flex items-center justify-center px-8 py-3 border border-transparent text-base font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 md:py-4 md:text-lg md:px-10">
                                Try the Demo
                            </a>
                        </div>
                        <div class="mt-3 rounded-md shadow sm:mt-0 sm:ml-3">
                            <a href="{{ route('register') }}" class="w-full flex items-center justify-center px-8 py-3 border border-transparent text-base font-medium rounded-md text-indigo-600 bg-white hover:bg-gray-50 md:py-4 md:text-lg md:px-10">
                                Get Started
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Features section -->
        <div class="relative py-16 bg-gray-50 overflow-hidden lg:py-24">
            <div class="relative max-w-xl mx-auto px-4 sm:px-6 lg:px-8 lg:max-w-7xl">
                <div class="relative">
                    <h2 class="text-center text-3xl leading-8 font-extrabold tracking-tight text-gray-900 sm:text-4xl">
                        Why Choose Hypno AI?
                    </h2>
                    <p class="mt-4 max-w-3xl mx-auto text-center text-xl text-gray-500">
                        Our platform combines cutting-edge AI technology with proven hypnosis techniques to deliver personalized results.
                    </p>
                </div>

                <div class="relative mt-12 lg:mt-24 lg:grid lg:grid-cols-2 lg:gap-8 lg:items-center">
                    <div class="relative">
                        <h3 class="text-2xl font-extrabold text-gray-900 tracking-tight sm:text-3xl">
                            Personalized Sessions
                        </h3>
                        <p class="mt-3 text-lg text-gray-500">
                            Every session is tailored to your specific needs, goals, and preferences. Our AI understands your unique situation and creates custom hypnosis scripts.
                        </p>
                        <dl class="mt-10 space-y-10">
                            <div class="relative">
                                <dt>
                                    <div class="absolute flex items-center justify-center h-12 w-12 rounded-md bg-indigo-500 text-white">
                                        <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                                        </svg>
                                    </div>
                                    <p class="ml-16 text-lg leading-6 font-medium text-gray-900">AI-Powered Generation</p>
                                </dt>
                                <dd class="mt-2 ml-16 text-base text-gray-500">
                                    Advanced language models create natural, engaging hypnosis scripts that adapt to your progress.
                                </dd>
                            </div>
                        </dl>
                    </div>

                    <div class="mt-10 -mx-4 relative lg:mt-0">
                        <div class="relative space-y-6">
                            <div class="space-y-8">
                                <div class="space-y-6">
                                    <div class="bg-white rounded-lg shadow-lg p-6">
                                        <h4 class="text-lg font-medium text-gray-900">Sleep Improvement</h4>
                                        <p class="mt-2 text-gray-500">Falling asleep faster and staying asleep longer with guided relaxation techniques.</p>
                                    </div>
                                    <div class="bg-white rounded-lg shadow-lg p-6">
                                        <h4 class="text-lg font-medium text-gray-900">Stress Reduction</h4>
                                        <p class="mt-2 text-gray-500">Learn to manage anxiety and find inner peace through progressive relaxation.</p>
                                    </div>
                                    <div class="bg-white rounded-lg shadow-lg p-6">
                                        <h4 class="text-lg font-medium text-gray-900">Confidence Building</h4>
                                        <p class="mt-2 text-gray-500">Develop unshakeable self-confidence and overcome limiting beliefs.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-guest-layout>
