<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LibraryController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\FavoritesController;
use App\Http\Controllers\PlaybackController;

Route::view('/', 'welcome');

Route::get('dashboard', fn () => view('dashboard'))
    ->middleware(['auth', 'verified'])
    ->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');

    Route::get('/library', [LibraryController::class, 'index'])->name('library.index');
    Route::get('/library/{track}', [LibraryController::class, 'show'])->name('library.show');

    Route::post('/favorites/{track}/toggle', [FavoritesController::class, 'toggle'])->name('favorites.toggle');
    Route::post('/playback', [PlaybackController::class, 'store'])->name('playback.store');
});

require __DIR__.'/auth.php';
