<?php

use Illuminate\Support\Facades\Route;

Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/', \App\Livewire\Home\Dashboard::class)->name('home');
    Route::get('/library', \App\Livewire\Library\BrowseTracks::class)->name('library.index');
    Route::get('/tracks/{track}', \App\Livewire\Library\TrackShow::class)->name('tracks.show');
    Route::get('/profile', \App\Livewire\Profile\Edit::class)->name('profile.edit');
    Route::get('/checkins', \App\Livewire\Checkins\Index::class)->name('checkins.index');
    Route::get('/favorites', \App\Livewire\Favorites\Index::class)->name('favorites.index');
});

require __DIR__.'/auth.php';
