<div wire:id="exfty-history-dropdown">
    @if($show)
        <div class="exfty-history-dropdown" 
             x-data="{ show: @entangle('show') }"
             x-show="show"
             x-transition:enter="transition ease-out duration-200"
             x-transition:enter-start="opacity-0 scale-95"
             x-transition:enter-end="opacity-100 scale-100"
             x-transition:leave="transition ease-in duration-150"
             x-transition:leave-start="opacity-100 scale-100"
             x-transition:leave-end="opacity-0 scale-95"
             onclick="event.stopPropagation()"
             style="left: {{ $position['left'] }}px; top: {{ $position['top'] }}px;">
            
            <div class="exfty-history-content">
                <div class="exfty-history-header">
                    <i class="fas fa-history me-2"></i>ExFty History
                    <button type="button" 
                            class="btn-close float-end" 
                            wire:click="hideHistory"
                            style="font-size: 0.7em; padding: 0.25rem;">
                    </button>
                </div>
                
                <div class="exfty-history-body">
                    @if($loading)
                        <div class="text-center py-3">
                            <div class="spinner-border spinner-border-sm text-primary" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                            <div class="mt-2 text-muted small">Loading history...</div>
                        </div>
                    @elseif(count($history) > 0)
                        <div class="exfty-history-list">
                            @foreach($history as $index => $change)
                                @if($change->new_exfty)
                                    <div class="exfty-history-item {{ $index === count($history) - 1 ? 'current' : '' }}">
                                        <div class="exfty-date">
                                            {{ date_format(date_create($change->new_exfty), "d M Y") }}
                                        </div>
                                        @if($index < count($history) - 1)
                                            <div class="exfty-changed">
                                                {{ date_format(date_create($change->created_at), "d/m H:i") }}
                                            </div>
                                        @else
                                            <div class="exfty-changed current-label">Current</div>
                                        @endif
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-3 text-muted">
                            <i class="fas fa-info-circle fa-2x mb-2"></i>
                            <div>No exfty history found</div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    @endif
</div>
