# Web Store Database Migrations Summary

This document outlines the database migrations created for the web store system based on the provided schema.

## Migration Files Created

### 1. Seasons Table (`2025_09_02_095118_create_seasons_table.php`)
**Purpose**: Store seasonal collections or releases
**Fields**:
- `id` - Primary key
- `name` - Season name (e.g., "Spring 2024", "Holiday Collection")
- `slug` - URL-friendly identifier
- `description` - Optional description
- `start_date` - Season start date
- `end_date` - Season end date
- `is_active` - Whether season is currently active
- `sort_order` - Display order
- `timestamps` - Created/updated timestamps

### 2. Categories Table (`2025_09_02_095129_create_categories_table.php`)
**Purpose**: Organize products into different types/groups
**Fields**:
- `id` - Primary key
- `name` - Category name (e.g., "T-Shirts", "Hoodies", "Accessories")
- `slug` - URL-friendly identifier
- `description` - Optional description
- `image` - Category image path
- `is_active` - Whether category is active
- `sort_order` - Display order
- `timestamps` - Created/updated timestamps

### 3. Items Table (`2025_09_02_095136_create_items_table.php`)
**Purpose**: Store product information
**Fields**:
- `id` - Primary key
- `name` - Product name
- `slug` - URL-friendly identifier
- `description` - Full product description
- `short_description` - Brief product description
- `seasons_id` - Foreign key to seasons table
- `categories_id` - Foreign key to categories table
- `initial_price` - Estimated price (as noted in schema)
- `actual_price` - Final invoiced price (as noted in schema)
- `sku` - Stock Keeping Unit (unique)
- `stock_quantity` - Available inventory
- `is_active` - Whether product is active
- `is_featured` - Whether product is featured
- `images` - JSON array of image paths
- `specifications` - JSON object for product specs
- `sort_order` - Display order
- `timestamps` - Created/updated timestamps

### 4. Colourways Table (`2025_09_02_095147_create_colourways_table.php`)
**Purpose**: Store color variations of items
**Fields**:
- `id` - Primary key
- `items_id` - Foreign key to items table
- `name` - Colorway name (e.g., "Red", "Blue", "Black/White")
- `color_code` - Hex color code
- `image` - Colorway-specific image
- `stock_quantity` - Available inventory for this color
- `is_active` - Whether colorway is active
- `sort_order` - Display order
- `timestamps` - Created/updated timestamps

### 5. Orders Table (`2025_09_02_095155_create_orders_table.php`)
**Purpose**: Store customer orders
**Fields**:
- `id` - Primary key
- `user_id` - Foreign key to users table
- `order_number` - Unique order identifier
- `status` - Order status (pending, confirmed, processing, shipped, delivered, cancelled)
- **Initial Pricing** (estimated):
  - `initial_subtotal` - Initial estimated subtotal
  - `initial_tax_amount` - Initial estimated tax
  - `initial_shipping_amount` - Initial estimated shipping
  - `initial_total_amount` - Initial estimated total
- **Invoiced Pricing** (final):
  - `invoiced_subtotal` - Final invoiced subtotal
  - `invoiced_tax_amount` - Final invoiced tax
  - `invoiced_shipping_amount` - Final invoiced shipping
  - `invoiced_total_amount` - Final invoiced total
- `currency` - Currency code (default: GBP)
- `zoho_invoice_number` - Zoho Books invoice number
- `supplier_invoice_number` - Supplier invoice number
- `notes` - Optional order notes
- `shipped_at` - Shipping timestamp
- `delivered_at` - Delivery timestamp
- `tracking_number` - Shipping tracking number
- `timestamps` - Created/updated timestamps

### 6. Order Lines Table (`2025_09_02_095200_create_order_lines_table.php`)
**Purpose**: Store individual items within orders (with denormalized data)
**Fields**:
- `id` - Primary key
- `orders_id` - Foreign key to orders table
- `colourways_id` - Foreign key to colourways table (nullable)
- **Denormalized Data** (as specified in schema):
  - `item_name` - Snapshot of item name at time of order
  - `item_description` - Snapshot of item description
  - `colourway_name` - Snapshot of colourway name
  - `item_sku` - Snapshot of item SKU
  - `unit_price` - Price at time of order
  - `quantity` - Quantity ordered
  - `line_total` - Total for this line (unit_price * quantity)
- `timestamps` - Created/updated timestamps

### 7. Addresses Table (`2025_09_02_095206_create_addresses_table.php`)
**Purpose**: Store user shipping/billing addresses
**Fields**:
- `id` - Primary key
- `users_id` - Foreign key to users table
- `type` - Address type (shipping, billing, both)
- `first_name` - First name
- `last_name` - Last name
- `company` - Company name (optional)
- `address_line_1` - Primary address line
- `address_line_2` - Secondary address line (optional)
- `city` - City
- `state_province` - State/Province (optional)
- `postal_code` - Postal/ZIP code
- `country` - Country
- `phone` - Phone number (optional)
- `is_default` - Whether this is the default address
- `timestamps` - Created/updated timestamps

## Key Design Decisions

1. **Denormalized Order Data**: The `order_lines` table stores snapshots of item data to preserve order history even if original items are deleted.

2. **Dual Pricing System**: Orders have both initial estimated pricing and final invoiced pricing, allowing for price adjustments between order placement and final invoicing.

3. **Flexible Address System**: Addresses can be marked as shipping, billing, or both, with support for default addresses.

4. **Soft Deletes**: All tables include `is_active` flags for soft deletion rather than hard deletes.

5. **JSON Fields**: Items use JSON fields for images and specifications to provide flexibility.

6. **Foreign Key Constraints**: Proper foreign key relationships with appropriate cascade/set null behaviors.

## Next Steps

To apply these migrations, run:
```bash
php artisan migrate
```

**Note**: These migrations have been created but not yet run, as requested.
