<?php

namespace App\Jobs;

use App\Models\Receipt;
use App\Services\ReceiptProcessingService;
use Illuminate\Bus\Batchable;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ProcessReceipt implements ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $tries = 3;
    public int $timeout = 60; // Reduced timeout for faster processing
    public int $maxExceptions = 2; // Fail faster on repeated exceptions

    public function __construct(public int $receiptId) {}

    public function handle(ReceiptProcessingService $processingService): void
    {
        $receipt = Receipt::with('lines')->find($this->receiptId);
        if (!$receipt) {
            return;
        }

        $processingService->process($receipt);
    }
}


