<?php

namespace App\Jobs;

use App\Models\Receipt;
use App\Services\ReceiptProcessingService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ProcessReceipt implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $tries = 3;
    public int $timeout = 120;

    public function __construct(public int $receiptId) {}

    public function handle(ReceiptProcessingService $processingService): void
    {
        $receipt = Receipt::with('lines')->find($this->receiptId);
        if (!$receipt) {
            return;
        }

        $processingService->process($receipt);
    }
}


